/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractMCPData
extends DefaultTask {
    private String key = "mappings";
    private Supplier<File> configSupplier;
    private File config;
    private boolean allowEmpty = false;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.srg"));

    @TaskAction
    public void run() throws IOException {
        MCPConfigV2 cfg = MCPConfigV2.getFromArchive(this.getConfig());
        try (ZipFile zip = new ZipFile(this.getConfig());){
            String path = cfg.getData(this.key.split("/"));
            if (path == null && "statics".equals(this.key)) {
                path = "config/static_methods.txt";
            }
            if (path == null) {
                this.error("Could not find data entry for '" + this.key + "'");
                return;
            }
            ZipEntry entry = zip.getEntry(path);
            if (entry == null) {
                this.error("Invalid config zip, Missing path '" + path + "'");
                return;
            }
            try (FileOutputStream out = new FileOutputStream(this.getOutput());){
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)out);
            }
        }
    }

    private void error(String message) throws IOException {
        if (!this.isAllowEmpty()) {
            throw new IllegalStateException(message);
        }
        if (this.getOutput().exists()) {
            this.getOutput().delete();
        }
        this.getOutput().createNewFile();
    }

    @InputFile
    public File getConfig() {
        if (this.config == null && this.configSupplier != null) {
            this.config = this.configSupplier.get();
        }
        return this.config;
    }

    public void setConfig(File value) {
        this.config = value;
        this.configSupplier = null;
    }

    public void setConfig(Supplier<File> valueSupplier) {
        this.configSupplier = valueSupplier;
        this.config = null;
    }

    @Input
    public String getKey() {
        return this.key;
    }

    public void setKey(String value) {
        this.key = value;
    }

    @Input
    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean value) {
        this.allowEmpty = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

