/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class RenameJar
extends JarExec {
    private Supplier<File> input;
    private File output;
    private Supplier<File> mappings;
    private List<Supplier<File>> extraMappings;

    public RenameJar() {
        this.tool = "net.md-5:SpecialSource:1.8.3:shaded";
        this.args = new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{mappings}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{mappings}", this.getMappings().getAbsolutePath());
        ArrayList<String> _args = new ArrayList<String>();
        for (String arg : this.getArgs()) {
            if ("{mappings}".equals(arg)) {
                String prefix = (String)_args.get(_args.size() - 1);
                _args.add(this.getMappings().getAbsolutePath());
                this.getExtraMappings().forEach(f -> {
                    _args.add(prefix);
                    _args.add(f.getAbsolutePath());
                });
                continue;
            }
            _args.add(replace.getOrDefault(arg, arg));
        }
        return _args;
    }

    @InputFile
    public File getMappings() {
        return this.mappings.get();
    }

    public void setMappings(Supplier<File> value) {
        this.mappings = value;
    }

    public void setMappings(File value) {
        this.mappings(value);
    }

    public void mappings(File value) {
        this.mappings(() -> value);
    }

    public void mappings(Supplier<File> value) {
        this.setMappings(value);
    }

    @Optional
    @InputFiles
    public List<File> getExtraMappings() {
        return this.extraMappings == null ? Collections.emptyList() : this.extraMappings.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public void setExtraMappingsDelayed(Collection<Supplier<File>> values) {
        this.extraMappings = new ArrayList<Supplier<File>>(values);
    }

    public void setExtraMappings(Collection<File> values) {
        ArrayList<Supplier<File>> _new = new ArrayList<Supplier<File>>();
        values.forEach(f -> _new.add(() -> f));
        this.extraMappings = _new;
    }

    public void extraMapping(File value) {
        this.extraMapping(() -> value);
    }

    public void extraMapping(Supplier<File> value) {
        if (this.extraMappings == null) {
            this.extraMappings = new ArrayList<Supplier<File>>();
        }
        this.extraMappings.add(value);
    }

    @InputFile
    public File getInput() {
        return this.input.get();
    }

    public void setInput(Supplier<File> value) {
        this.input = value;
    }

    public void setInput(File value) {
        this.setInput(() -> value);
    }

    public void input(File value) {
        this.input(() -> value);
    }

    public void input(Supplier<File> value) {
        this.setInput(value);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }

    public void output(File value) {
        this.setOutput(value);
    }
}

