/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.minecraftforge.gradle.common.util.ManifestJson;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadMCMeta
extends DefaultTask {
    private static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final Gson GSON = new GsonBuilder().create();
    private String mcVersion;
    private File manifest = this.getProject().file((Object)("build/" + this.getName() + "/manifest.json"));
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/version.json"));

    @TaskAction
    public void downloadMCMeta() throws IOException {
        block13: {
            try (InputStream manin = new URL(MANIFEST_URL).openStream();){
                URL url = ((ManifestJson)GSON.fromJson((Reader)new InputStreamReader(manin), ManifestJson.class)).getUrl(this.getMCVersion());
                if (url != null) {
                    FileUtils.copyURLToFile((URL)url, (File)this.getOutput());
                    break block13;
                }
                throw new RuntimeException("Missing version from manifest: " + this.getMCVersion());
            }
        }
    }

    @Input
    public String getMCVersion() {
        return this.mcVersion;
    }

    public File getManifest() {
        return this.manifest;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setMCVersion(String mcVersion) {
        this.mcVersion = mcVersion;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

