/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadMavenArtifact
extends DefaultTask {
    private boolean changing = false;
    private String artifact;
    private Artifact _artifact;
    private File output;

    public DownloadMavenArtifact() {
        this.getOutputs().upToDateWhen(task -> false);
    }

    public String getResolvedVersion() {
        return MavenArtifactDownloader.getVersion(this.getProject(), this._artifact.getDescriptor());
    }

    @Input
    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String value) {
        this.artifact = value;
        this._artifact = Artifact.from(value);
    }

    @Input
    public boolean getChanging() {
        return this.changing;
    }

    public void setChanging(boolean value) {
        this.changing = value;
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.output = this.getProject().file((Object)("build/" + this.getName() + "/output." + this._artifact.getExtension()));
        }
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @TaskAction
    public void run() throws IOException {
        File out = MavenArtifactDownloader.download(this.getProject(), this._artifact.getDescriptor(), this.getChanging());
        this.setDidWork(out != null && out.exists());
        if (FileUtils.contentEquals((File)out, (File)this.output)) {
            return;
        }
        if (this.output.exists()) {
            this.output.delete();
        }
        if (!this.output.getParentFile().exists()) {
            this.output.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)out, (File)this.output);
    }
}

