/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class DynamicJarExec
extends JarExec {
    private File input;
    private File output;
    private Map<String, File> data;

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        if (this.data != null) {
            this.data.forEach((key, value) -> replace.put('{' + key + '}', value.getAbsolutePath()));
        }
        return Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
    }

    @InputFiles
    @Optional
    public Collection<File> getData() {
        return this.data == null ? Collections.emptyList() : this.data.values();
    }

    public void data(String key, File file) {
        this.setData(key, file);
    }

    public void setData(String key, File file) {
        if (this.data == null) {
            this.data = new HashMap<String, File>();
        }
        this.data.put(key, file);
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/output.jar")));
        }
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

