/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class GenerateSRG
extends DefaultTask {
    private File srg;
    private String mapping;
    private IMappingFile.Format format = IMappingFile.Format.TSRG;
    private boolean notch = false;
    private boolean reverse = false;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.tsrg"));

    @TaskAction
    public void apply() throws IOException {
        File names = this.findNames(this.getMappings());
        if (names == null) {
            throw new IllegalStateException("Invalid mappings: " + this.getMappings() + " Could not find archive");
        }
        IMappingFile input = IMappingFile.load((File)this.srg);
        if (!this.getNotch()) {
            input = input.reverse().chain(input);
        }
        final McpNames map = McpNames.load(names);
        IMappingFile ret = input.rename(new IRenamer(){

            public String rename(IMappingFile.IField value) {
                return map.rename(value.getMapped());
            }

            public String rename(IMappingFile.IMethod value) {
                return map.rename(value.getMapped());
            }
        });
        ret.write(this.getOutput().toPath(), this.getFormat(), this.getReverse());
    }

    private File findNames(String mapping) {
        int idx = mapping.lastIndexOf(95);
        if (idx == -1) {
            return null;
        }
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = MCPRepo.getMappingDep(channel, version);
        return MavenArtifactDownloader.generate(this.getProject(), desc, false);
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @Input
    public String getMappings() {
        return this.mapping;
    }

    public void setMappings(String value) {
        this.mapping = value;
    }

    @Input
    public IMappingFile.Format getFormat() {
        return this.format;
    }

    public void setFormat(IMappingFile.Format value) {
        this.format = value;
    }

    public void setFormat(String value) {
        this.setFormat(IMappingFile.Format.valueOf((String)value));
    }

    @Input
    public boolean getNotch() {
        return this.notch;
    }

    public void setNotch(boolean value) {
        this.notch = value;
    }

    @Input
    public boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

