/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.graph3;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import dev.gigaherz.graph3.ContextDataFactory;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class Graph<T extends Mergeable<T>> {
    private final Set<Node<T>> nodeList = Sets.newHashSet();
    private final Multimap<Node<T>, Node<T>> neighbours = HashMultimap.create();
    private final Multimap<Node<T>, Node<T>> reverseNeighbours = HashMultimap.create();
    private final Map<GraphObject<T>, Node<T>> objects = Maps.newHashMap();
    private T contextData;

    public static <T extends Mergeable<T>> void connect(GraphObject<T> object1, GraphObject<T> object2) {
        Graph.connect(object1, object2, null);
    }

    public static <T extends Mergeable<T>> void connect(GraphObject<T> object1, GraphObject<T> object2, @Nullable ContextDataFactory<T> contextDataFactory) {
        Graph.connect(object1, object2, Graph::new, contextDataFactory);
    }

    public static <T extends Mergeable<T>> void connect(GraphObject<T> object1, GraphObject<T> object2, Supplier<Graph<T>> graphFactory, @Nullable ContextDataFactory<T> contextDataFactory) {
        Graph<T> graph1 = object1.getGraph();
        Graph<T> graph2 = object2.getGraph();
        Graph<T> target = graph1;
        if (graph1 != null && graph2 != null) {
            super.mergeWith(graph2);
        } else if (graph1 != null) {
            super.addNode(object2);
        } else if (graph2 != null) {
            target = graph2;
            super.addNode(object1);
        } else {
            target = graphFactory.get();
            if (contextDataFactory != null) {
                target.contextData = contextDataFactory.create(target);
            }
        }
        target.addSingleEdge(object1, object2);
    }

    public static <T extends Mergeable<T>> void integrate(GraphObject<T> object, List<GraphObject<T>> neighbours) {
        Graph.integrate(object, neighbours, null);
    }

    public static <T extends Mergeable<T>> void integrate(GraphObject<T> object, List<GraphObject<T>> neighbours, @Nullable ContextDataFactory<T> contextDataFactory) {
        Graph.integrate(object, neighbours, Graph::new, contextDataFactory);
    }

    public static <T extends Mergeable<T>> void integrate(GraphObject<T> object, List<GraphObject<T>> neighbours, Supplier<Graph<T>> graphFactory, @Nullable ContextDataFactory<T> contextDataFactory) {
        Graph target;
        HashSet otherGraphs = Sets.newHashSet();
        for (GraphObject<T> neighbour : neighbours) {
            Graph<T> otherGraph = neighbour.getGraph();
            if (otherGraph == null) continue;
            otherGraphs.add(otherGraph);
        }
        if (otherGraphs.size() > 0) {
            target = (Graph)otherGraphs.iterator().next();
        } else {
            target = graphFactory.get();
            if (contextDataFactory != null) {
                target.contextData = contextDataFactory.create(target);
            }
        }
        target.addNodeAndEdges(object, neighbours);
    }

    public T getContextData() {
        return this.contextData;
    }

    public void setContextData(T contextData) {
        this.contextData = contextData;
    }

    public void addNodeAndEdges(GraphObject<T> object, Iterable<GraphObject<T>> neighbours) {
        if (object.getGraph() != null) {
            throw new IllegalArgumentException("The object is already in another graph.");
        }
        if (this.objects.containsKey(object)) {
            throw new IllegalStateException("The object is already in this graph.");
        }
        Node<T> node = new Node<T>(this, object);
        object.setGraph(this);
        this.objects.put(object, node);
        this.nodeList.add(node);
        this.verify();
        this.addDirectedEdges(object, neighbours);
    }

    public void addDirectedEdges(GraphObject<T> object, Iterable<GraphObject<T>> neighbours) {
        Node<T> node = this.objects.get(object);
        for (GraphObject<T> neighbour : neighbours) {
            this.addSingleEdgeInternal(node, neighbour);
        }
        this.verify();
    }

    public void addSingleEdge(GraphObject<T> object, GraphObject<T> neighbour) {
        Node<T> node = this.objects.get(object);
        this.addSingleEdgeInternal(node, neighbour);
        this.verify();
    }

    public void removeSingleEdge(GraphObject<T> object, GraphObject<T> neighbour) {
        Node<T> node = this.objects.get(object);
        Node<T> other = this.objects.get(neighbour);
        this.neighbours.remove(node, other);
        this.reverseNeighbours.remove(other, node);
        this.verify();
        this.splitAfterRemoval();
    }

    public void remove(GraphObject<T> object) {
        if (object.getGraph() != this) {
            throw new IllegalArgumentException("The object is not of this graph.");
        }
        object.setGraph(null);
        Node<T> node = this.objects.get(object);
        if (node == null) {
            throw new IllegalStateException("The graph is broken.");
        }
        this.nodeList.remove(node);
        HashSet neighs = Sets.newHashSet((Iterable)this.neighbours.get(node));
        neighs.addAll(this.reverseNeighbours.get(node));
        for (Node n : neighs) {
            this.neighbours.remove((Object)n, node);
            this.reverseNeighbours.remove(node, (Object)n);
            this.neighbours.remove(node, (Object)n);
            this.reverseNeighbours.remove((Object)n, node);
        }
        this.objects.remove(object);
        this.verify();
        this.splitAfterRemoval();
    }

    public Collection<GraphObject<T>> getObjects() {
        return Collections.unmodifiableSet(this.objects.keySet());
    }

    public Collection<GraphObject<T>> acquireObjects() {
        return this.getObjects();
    }

    public void releaseObjects() {
    }

    public Collection<GraphObject<T>> getNeighbours(GraphObject<T> object) {
        HashSet others = Sets.newHashSet();
        for (Node n : this.neighbours.get(this.objects.get(object))) {
            others.add(n.getObject());
        }
        return ImmutableSet.copyOf((Collection)others);
    }

    public boolean contains(GraphObject<T> object) {
        Node<T> node = this.objects.get(object);
        return node != null && this.nodeList.contains(node);
    }

    private void addNode(GraphObject<T> object) {
        if (object.getGraph() != null) {
            throw new IllegalArgumentException("The object is already in another graph.");
        }
        if (this.objects.containsKey(object)) {
            throw new IllegalStateException("The object is already in this graph.");
        }
        Node<T> node = new Node<T>(this, object);
        object.setGraph(this);
        this.objects.put(object, node);
        this.nodeList.add(node);
    }

    private void addSingleEdgeInternal(Node<T> node, GraphObject<T> neighbour) {
        Graph<T> g = neighbour.getGraph();
        if (g == null) {
            throw new IllegalArgumentException("The neighbour object is not in a graph.");
        }
        if (g != this) {
            this.mergeWith(g);
        }
        if (neighbour.getGraph() != this) {
            throw new IllegalStateException("The graph merging didn't work as expected.");
        }
        Node<T> n = this.objects.get(neighbour);
        this.neighbours.put(node, n);
        this.reverseNeighbours.put(n, node);
    }

    private void splitAfterRemoval() {
        if (this.nodeList.size() == 0) {
            return;
        }
        HashSet remaining = Sets.newHashSet(this.nodeList);
        HashSet seen = Sets.newHashSet();
        ArrayDeque succ = Queues.newArrayDeque();
        Node node = (Node)remaining.iterator().next();
        succ.add(node);
        seen.add(node);
        remaining.remove(node);
        while (succ.size() > 0) {
            Node c = (Node)succ.poll();
            for (Node n : this.neighbours.get((Object)c)) {
                if (seen.contains(n)) continue;
                seen.add(n);
                succ.add(n);
                remaining.remove(n);
            }
            for (Node n : this.reverseNeighbours.get((Object)c)) {
                if (seen.contains(n)) continue;
                seen.add(n);
                succ.add(n);
                remaining.remove(n);
            }
        }
        while (remaining.size() > 0) {
            node = (Node)remaining.iterator().next();
            succ.add(node);
            seen.add(node);
            remaining.remove(node);
            Graph<T> newGraph = new Graph<T>();
            if (this.contextData != null) {
                newGraph.contextData = this.contextData.copy();
            }
            while (succ.size() > 0) {
                Node c = (Node)succ.poll();
                for (Node n : this.neighbours.get((Object)c)) {
                    if (seen.contains(n)) continue;
                    seen.add(n);
                    succ.add(n);
                    remaining.remove(n);
                }
                for (Node n : this.reverseNeighbours.get((Object)c)) {
                    if (seen.contains(n)) continue;
                    seen.add(n);
                    succ.add(n);
                    remaining.remove(n);
                }
                this.nodeList.remove(c);
                newGraph.nodeList.add(c);
                newGraph.neighbours.putAll((Object)c, (Iterable)this.neighbours.get((Object)c));
                newGraph.reverseNeighbours.putAll((Object)c, (Iterable)this.reverseNeighbours.get((Object)c));
                this.neighbours.removeAll((Object)c);
                this.reverseNeighbours.removeAll((Object)c);
                this.objects.remove(c.getObject());
                newGraph.objects.put(c.getObject(), c);
                c.owner = newGraph;
                c.getObject().setGraph(newGraph);
            }
            this.verify();
        }
        this.verify();
    }

    private void mergeWith(Graph<T> graph) {
        this.nodeList.addAll(graph.nodeList);
        this.objects.putAll(graph.objects);
        this.neighbours.putAll(graph.neighbours);
        this.reverseNeighbours.putAll(graph.reverseNeighbours);
        for (Node<T> n : graph.nodeList) {
            n.getObject().setGraph(this);
        }
        if (this.contextData != null && graph.contextData != null) {
            this.contextData = this.contextData.mergeWith(graph.contextData);
        } else if (graph.contextData != null) {
            this.contextData = graph.contextData;
        }
        this.verify();
    }

    private void verify() {
        for (Node<T> node : this.nodeList) {
            for (Node other : this.neighbours.get(node)) {
                if (this.nodeList.contains(other)) continue;
                throw new IllegalStateException("Graph is broken!");
            }
            if (this.objects.containsKey(node.getObject())) continue;
            throw new IllegalStateException("Graph is broken!");
        }
        for (Node<T> other : this.objects.values()) {
            if (this.nodeList.contains(other)) continue;
            throw new IllegalStateException("Graph is broken!");
        }
    }

    private static class Node<T extends Mergeable<T>> {
        private Graph<T> owner;
        private final GraphObject<T> object;

        public Graph<T> getOwner() {
            return this.owner;
        }

        public GraphObject<T> getObject() {
            return this.object;
        }

        public Node(Graph<T> owner, GraphObject<T> object) {
            this.owner = owner;
            this.object = object;
        }
    }
}

