/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.graph3;

import dev.gigaherz.graph3.ContextDataFactory;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nullable;

public class ConcurrentGraph<T extends Mergeable<T>>
extends Graph<T> {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public static <T extends Mergeable<T>> void connect(GraphObject<T> object1, GraphObject<T> object2) {
        ConcurrentGraph.connect(object1, object2, null);
    }

    public static <T extends Mergeable<T>> void connect(GraphObject<T> object1, GraphObject<T> object2, @Nullable ContextDataFactory<T> contextDataFactory) {
        ConcurrentGraph.connect(object1, object2, ConcurrentGraph::new, contextDataFactory);
    }

    public static <T extends Mergeable<T>> void integrate(GraphObject<T> object, List<GraphObject<T>> neighbours) {
        ConcurrentGraph.integrate(object, neighbours, null);
    }

    public static <T extends Mergeable<T>> void integrate(GraphObject<T> object, List<GraphObject<T>> neighbours, @Nullable ContextDataFactory<T> contextDataFactory) {
        ConcurrentGraph.integrate(object, neighbours, ConcurrentGraph::new, contextDataFactory);
    }

    @Override
    public T getContextData() {
        this.readLock.lock();
        try {
            Object t = super.getContextData();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setContextData(T contextData) {
        this.writeLock.lock();
        try {
            super.setContextData(contextData);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addNodeAndEdges(GraphObject<T> object, Iterable<GraphObject<T>> neighbours) {
        this.writeLock.lock();
        try {
            super.addNodeAndEdges(object, neighbours);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addDirectedEdges(GraphObject<T> object, Iterable<GraphObject<T>> neighbours) {
        this.writeLock.lock();
        try {
            super.addDirectedEdges(object, neighbours);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addSingleEdge(GraphObject<T> object, GraphObject<T> neighbour) {
        this.writeLock.lock();
        try {
            super.addSingleEdge(object, neighbour);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeSingleEdge(GraphObject<T> object, GraphObject<T> neighbour) {
        this.writeLock.lock();
        try {
            super.removeSingleEdge(object, neighbour);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeNonDirectionalSingleEdge(GraphObject<T> object1, GraphObject<T> object2) {
        this.writeLock.lock();
        try {
            super.removeNonDirectionalSingleEdge(object1, object2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(GraphObject<T> object) {
        this.writeLock.lock();
        try {
            super.remove(object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @Deprecated
    public Collection<GraphObject<T>> getObjects() {
        return super.getObjects();
    }

    @Override
    public Collection<GraphObject<T>> acquireObjects() {
        this.readLock.lock();
        return super.getObjects();
    }

    @Override
    public void releaseObjects() {
        this.readLock.unlock();
    }

    @Override
    public Collection<GraphObject<T>> getNeighbours(GraphObject<T> object) {
        this.readLock.lock();
        try {
            Collection<GraphObject<T>> collection = super.getNeighbours(object);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<GraphObject<T>> getNonDirectionalNeighbours(GraphObject<T> object) {
        this.readLock.lock();
        try {
            Collection<GraphObject<T>> collection = super.getNonDirectionalNeighbours(object);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean contains(GraphObject<T> object) {
        this.readLock.lock();
        try {
            boolean bl = super.contains(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

