/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonmerger;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jsonmerger")
public class JsonMerger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson SERIALIZER = new GsonBuilder().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement combineAllJsonResources(IResourceManager resourceManager, ResourceLocation location) {
        try {
            List list;
            List allResources = resourceManager.func_199004_b(location);
            List resourceList = allResources.size() == 1 ? allResources : Lists.reverse((List)allResources);
            ArrayList results = Lists.newArrayList();
            boolean stopping = false;
            for (IResource resource : resourceList) {
                if (stopping) {
                    resource.close();
                    continue;
                }
                try {
                    IResource t = resource;
                    Throwable throwable = null;
                    try {
                        InputStream is = t.func_199027_b();
                        Throwable throwable2 = null;
                        try {
                            InputStreamReader rd = new InputStreamReader(is);
                            Throwable throwable3 = null;
                            try {
                                JsonElement jsonElement = (JsonElement)SERIALIZER.fromJson((Reader)rd, JsonElement.class);
                                if (jsonElement == null) {
                                    LOGGER.error("Couldn't load data from {} as it's null or empty", (Object)location);
                                    JsonElement jsonElement2 = null;
                                    return jsonElement2;
                                }
                                results.add(jsonElement);
                                if (!JsonMerger.isOverwriteMode(jsonElement)) continue;
                                stopping = true;
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (rd == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        rd.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                rd.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (t == null) continue;
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        t.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error reading JSON from {}", (Object)location, (Object)e);
                }
            }
            if (results.size() == 1) {
                list = results;
                return JsonMerger.combineAllJsonResources(list);
            }
            list = Lists.reverse((List)results);
            return JsonMerger.combineAllJsonResources(list);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to close file stream for %s", location), e);
        }
    }

    public static JsonElement combineAllJsonResources(List<JsonElement> elements) {
        JsonElement merged = null;
        for (JsonElement next : elements) {
            if (merged == null) {
                merged = next;
                continue;
            }
            merged = JsonMerger.combineJsonElements(merged, next, MergeMode.OVERWRITE);
        }
        return merged;
    }

    private static JsonElement combineJsonElements(JsonElement first, JsonElement second, MergeMode parentMode) {
        JsonObject secondObj;
        MergeMode mode = parentMode;
        if (second.isJsonObject() && (secondObj = second.getAsJsonObject()).has("_jm_combine")) {
            String modeName;
            JsonObject settings = secondObj.getAsJsonObject("_jm_combine");
            if (settings.has("mode") && (mode = MergeMode.byName(modeName = settings.get("mode").getAsString())) == null) {
                throw new JsonSyntaxException(String.format("Unknown combine mode: %s", modeName));
            }
            if (settings.has("value")) {
                second = settings.get("value");
                for (Map.Entry child : secondObj.entrySet()) {
                    if (((String)child.getKey()).equals("_jm_combine")) continue;
                    throw new JsonSyntaxException("Objects must not have content other than '_jm_combine' if they use the 'value' feature.");
                }
            }
        }
        return JsonMerger.getCombinedInternal(first, second, mode);
    }

    private static JsonElement getCombinedInternal(JsonElement first, JsonElement second, MergeMode mode) {
        if (mode == MergeMode.OVERWRITE) {
            return second;
        }
        if (first.isJsonObject()) {
            if (!second.isJsonObject()) {
                throw new JsonSyntaxException("The combining counterpart for a json object must be another json object");
            }
            if (mode == MergeMode.COMBINE) {
                return JsonMerger.combineObjects(first.getAsJsonObject(), second.getAsJsonObject());
            }
            throw new JsonSyntaxException(String.format("Invalid combine mode for a json object: %s. Allowed: overwrite, combine", new Object[]{mode}));
        }
        if (first.isJsonArray()) {
            switch (mode) {
                case COMBINE: {
                    return JsonMerger.concatenateArrays(first.getAsJsonArray(), second.getAsJsonArray());
                }
                case ZIP: {
                    return JsonMerger.zipArrays(first.getAsJsonArray(), second.getAsJsonArray());
                }
            }
            throw new JsonSyntaxException(String.format("Invalid combine mode for a json array: %s. Allowed: overwrite, combine, zip", new Object[]{mode}));
        }
        if (first.isJsonNull()) {
            if (mode != MergeMode.COMBINE) {
                throw new JsonSyntaxException(String.format("Invalid combine mode for a json null: %s", new Object[]{mode}));
            }
        } else if (mode != MergeMode.COMBINE) {
            throw new JsonSyntaxException(String.format("Invalid combine mode for a json primitive: %s", new Object[]{mode}));
        }
        return second;
    }

    public static JsonElement combineObjects(JsonObject first, JsonObject second) {
        JsonElement value;
        String key;
        JsonObject result = new JsonObject();
        ArrayList keysToDelete = Lists.newArrayList();
        for (Map.Entry entry : first.entrySet()) {
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            if (second.has(key)) {
                JsonElement secondElement = second.get(key);
                if (JsonMerger.getMode(secondElement, MergeMode.COMBINE) == MergeMode.DELETE) {
                    keysToDelete.add(key);
                    continue;
                }
                result.add(key, JsonMerger.combineJsonElements(value, secondElement, MergeMode.COMBINE));
                continue;
            }
            result.add(key, value);
        }
        for (Map.Entry entry : second.entrySet()) {
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            if (result.has(key)) continue;
            result.add(key, value);
        }
        for (String key2 : keysToDelete) {
            result.remove(key2);
        }
        return result;
    }

    private static JsonElement zipArrays(JsonArray first, JsonArray second) {
        JsonArray a = new JsonArray();
        int end = Math.min(first.size(), second.size());
        for (int i = 0; i < end; ++i) {
            a.add(JsonMerger.combineJsonElements(first.get(i), second.get(i), MergeMode.COMBINE));
        }
        return null;
    }

    private static JsonElement concatenateArrays(JsonArray first, JsonArray second) {
        int i;
        ArrayList elements = Lists.newArrayList();
        for (i = 0; i < first.size(); ++i) {
            elements.add(first.get(i));
        }
        for (i = 0; i < second.size(); ++i) {
            JsonMerger.processJsonArrayElement(elements, second.get(i));
        }
        JsonArray result = new JsonArray();
        for (JsonElement element : elements) {
            result.add(element);
        }
        return result;
    }

    private static void processJsonArrayElement(List<JsonElement> parent, JsonElement second) {
        JsonObject secondObj;
        MergeMode mode = MergeMode.APPEND;
        Integer index = null;
        JsonElement find = null;
        boolean silent = false;
        boolean exact = false;
        boolean after = false;
        if (second.isJsonObject() && (secondObj = second.getAsJsonObject()).has("_jm_combine")) {
            String modeName;
            JsonObject settings = secondObj.getAsJsonObject("_jm_combine");
            if (settings.has("mode") && (mode = MergeMode.byName(modeName = settings.get("mode").getAsString())) == null) {
                throw new JsonSyntaxException(String.format("Unknown combine mode: %s", modeName));
            }
            if (settings.has("value")) {
                second = settings.get("value");
            }
            if (settings.has("index")) {
                if (mode == MergeMode.APPEND) {
                    throw new JsonSyntaxException("Index is not available in append mode.");
                }
                index = settings.get("index").getAsInt();
            }
            if (settings.has("find")) {
                if (index != null) {
                    throw new JsonSyntaxException("Array replace option 'find' can not be used at the same time as 'index'.");
                }
                if (mode == MergeMode.APPEND) {
                    throw new JsonSyntaxException("Find is not available in append mode.");
                }
                find = settings.get("find");
            }
            if (settings.has("silent")) {
                silent = settings.get("silent").getAsBoolean();
            }
            if (settings.has("exact") && (exact = settings.get("exact").getAsBoolean()) && find == null) {
                throw new JsonSyntaxException("Exact is only available when using find.");
            }
            if (settings.has("after") && (after = settings.get("after").getAsBoolean()) && mode != MergeMode.INSERT) {
                throw new JsonSyntaxException("After is only available in insert mode.");
            }
        }
        switch (mode) {
            case APPEND: {
                parent.add(second);
                break;
            }
            case INSERT: {
                JsonMerger.processArrayOperation(parent, second, index, find, exact, silent, after, parent::add);
                break;
            }
            case OVERWRITE: {
                JsonMerger.processArrayOperation(parent, second, index, find, exact, silent, after, parent::set);
                break;
            }
            case COMBINE: {
                JsonMerger.processArrayOperation(parent, second, index, find, exact, silent, after, (i, e) -> parent.set((int)i, JsonMerger.combineJsonElements((JsonElement)parent.get((int)i), e, MergeMode.COMBINE)));
                break;
            }
            case DELETE: {
                JsonMerger.processArrayOperation(parent, second, index, find, exact, silent, after, (i, e) -> parent.remove(i));
                break;
            }
            default: {
                throw new JsonSyntaxException(String.format("Invalid combine mode for children of json arrays: %s. Allowed: append, combine, overwrite, insert", new Object[]{mode}));
            }
        }
    }

    private static void processArrayOperation(List<JsonElement> parent, JsonElement second, Integer index, JsonElement find, boolean exact, boolean silent, boolean after, BiConsumer<Integer, JsonElement> operation) {
        if (index == null && find == null) {
            throw new JsonSyntaxException("Modes other than append mode must specify an 'index' or a 'find' search pattern.");
        }
        if (index != null) {
            if (after) {
                throw new JsonSyntaxException("After is not available when index is used.");
            }
            operation.accept(index, second);
        } else {
            boolean found = false;
            for (int i = 0; i < parent.size(); ++i) {
                if (!JsonMerger.compareWithPattern(parent.get(i), find, exact)) continue;
                if (after) {
                    ++i;
                }
                operation.accept(i, second);
                found = true;
                break;
            }
            if (!found && !silent) {
                LOGGER.warn("Search pattern did not find a target while looking for: {}", (Object)find.toString());
            }
        }
    }

    private static boolean compareWithPattern(JsonElement base, JsonElement pattern, boolean exact) {
        if (pattern.isJsonObject()) {
            if (!base.isJsonObject()) {
                return false;
            }
            return JsonMerger.compareObjectWithPattern(base.getAsJsonObject(), pattern.getAsJsonObject(), exact);
        }
        if (pattern.isJsonArray()) {
            if (!base.isJsonArray()) {
                return false;
            }
            return JsonMerger.compareArrayWithPattern(base.getAsJsonArray(), pattern.getAsJsonArray(), exact);
        }
        return base.equals(pattern);
    }

    private static boolean compareArrayWithPattern(JsonArray array, JsonArray pattern, boolean exact) {
        if (exact) {
            if (array.size() != pattern.size()) {
                return false;
            }
            for (int i = 0; i < pattern.size(); ++i) {
                if (JsonMerger.compareWithPattern(array.get(i), pattern.get(i), true)) continue;
                return false;
            }
        }
        if (pattern.size() > array.size()) {
            return false;
        }
        BitSet processedIndices = new BitSet();
        for (int i = 0; i < pattern.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < array.size(); ++j) {
                if (processedIndices.get(j) || !JsonMerger.compareWithPattern(array.get(j), pattern.get(i), true)) continue;
                processedIndices.set(j);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean compareObjectWithPattern(JsonObject obj, JsonObject pattern, boolean exact) {
        String key;
        for (Map.Entry entry : pattern.entrySet()) {
            key = (String)entry.getKey();
            if (!obj.has(key)) {
                return false;
            }
            if (JsonMerger.compareWithPattern(obj.get(key), (JsonElement)entry.getValue(), exact)) continue;
            return false;
        }
        if (exact) {
            for (Map.Entry entry : pattern.entrySet()) {
                key = (String)entry.getKey();
                if (pattern.has(key)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isOverwriteMode(JsonElement jsonElement) {
        return JsonMerger.getMode(jsonElement, MergeMode.OVERWRITE) == MergeMode.OVERWRITE;
    }

    private static MergeMode getMode(JsonElement jsonElement, MergeMode fallback) {
        if (!jsonElement.isJsonObject()) {
            return fallback;
        }
        JsonObject obj = jsonElement.getAsJsonObject();
        if (!obj.has("_jm_combine")) {
            return fallback;
        }
        JsonObject settings = obj.getAsJsonObject("_jm_combine");
        if (!settings.has("mode")) {
            return fallback;
        }
        String modeName = settings.get("mode").getAsString();
        MergeMode mode = MergeMode.byName(modeName);
        if (mode == null) {
            throw new JsonSyntaxException(String.format("Unknown combine mode: %s", modeName));
        }
        return mode;
    }

    public static enum MergeMode {
        OVERWRITE("overwrite"),
        COMBINE("combine"),
        ZIP("zip"),
        APPEND("append"),
        INSERT("insert"),
        DELETE("delete");

        private final String name;
        public static final ImmutableList<MergeMode> VALUES;

        private MergeMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static MergeMode byName(String name) {
            for (MergeMode m : VALUES) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            return null;
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])MergeMode.values());
        }
    }
}

