/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.client.BlockColorHandler;
import dev.gigaherz.jsonthings.things.parsers.ArmorMaterialParser;
import dev.gigaherz.jsonthings.things.parsers.BlockParser;
import dev.gigaherz.jsonthings.things.parsers.BlockSetTypeParser;
import dev.gigaherz.jsonthings.things.parsers.ConsumableParser;
import dev.gigaherz.jsonthings.things.parsers.CreativeModeTabParser;
import dev.gigaherz.jsonthings.things.parsers.FluidParser;
import dev.gigaherz.jsonthings.things.parsers.FluidTypeParser;
import dev.gigaherz.jsonthings.things.parsers.FoodPropertiesParser;
import dev.gigaherz.jsonthings.things.parsers.ItemParser;
import dev.gigaherz.jsonthings.things.parsers.MobEffectInstanceParser;
import dev.gigaherz.jsonthings.things.parsers.ShapeParser;
import dev.gigaherz.jsonthings.things.parsers.SoundEventParser;
import dev.gigaherz.jsonthings.things.parsers.SoundTypeParser;
import dev.gigaherz.jsonthings.things.parsers.ThingResourceManager;
import dev.gigaherz.jsonthings.things.parsers.ToolMaterialParser;
import dev.gigaherz.jsonthings.things.scripting.ScriptParser;
import dev.gigaherz.jsonthings.util.CustomPackType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.NamedRenderTypeManager;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@EventBusSubscriber(modid="jsonthings")
@Mod(value="jsonthings")
public class JsonThings {
    public static final String MODID = "jsonthings";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static BlockParser blockParser;
    public static ItemParser itemParser;
    public static FluidParser fluidParser;
    public static FoodPropertiesParser foodPropertiesParser;
    public static ConsumableParser consumableParser;
    public static ShapeParser shapeParser;
    public static ToolMaterialParser toolMaterialParser;
    public static FluidTypeParser fluidTypeParser;
    public static ArmorMaterialParser armorMaterialParser;
    public static CreativeModeTabParser creativeModeTabParser;
    public static MobEffectInstanceParser mobEffectInstanceParser;
    public static BlockSetTypeParser blockSetTypeParser;
    public static SoundEventParser soundEventParser;
    public static SoundTypeParser soundTypeParser;
    private static CompletableFuture<ThingResourceManager> loaderFuture;

    public JsonThings(IEventBus bus) {
        ThingResourceManager manager = ThingResourceManager.instance();
        ScriptParser.enable(manager);
        blockParser = manager.registerParser(new BlockParser(bus));
        itemParser = manager.registerParser(new ItemParser(bus));
        fluidParser = manager.registerParser(new FluidParser(bus));
        foodPropertiesParser = manager.registerParser(new FoodPropertiesParser());
        consumableParser = manager.registerParser(new ConsumableParser());
        shapeParser = manager.registerParser(new ShapeParser());
        toolMaterialParser = manager.registerParser(new ToolMaterialParser());
        fluidTypeParser = manager.registerParser(new FluidTypeParser(bus));
        armorMaterialParser = manager.registerParser(new ArmorMaterialParser(bus));
        creativeModeTabParser = manager.registerParser(new CreativeModeTabParser(bus));
        mobEffectInstanceParser = manager.registerParser(new MobEffectInstanceParser());
        blockSetTypeParser = manager.registerParser(new BlockSetTypeParser());
        soundEventParser = manager.registerParser(new SoundEventParser(bus));
        soundTypeParser = manager.registerParser(new SoundTypeParser());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void construct(FMLConstructModEvent event) {
        event.enqueueWork(() -> {
            ThingResourceManager instance = ThingResourceManager.instance();
            ResourcePackLoader.populatePackRepository((PackRepository)instance.getRepository(), (PackType)CustomPackType.THINGS, (boolean)false);
            loaderFuture = instance.beginLoading();
        });
    }

    @SubscribeEvent
    public static void finishLoading(NewRegistryEvent event) {
        ThingResourceManager.instance().waitForLoading(loaderFuture);
        loaderFuture = null;
    }

    @SubscribeEvent
    public static void packFinder(AddPackFindersEvent event) {
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: 
            case SERVER_DATA: {
                event.addRepositorySource(ThingResourceManager.instance().getWrappedPackFinder(event.getPackType()));
                break;
            }
        }
    }

    @SubscribeEvent
    public static void validateThings(FMLCommonSetupEvent event) {
        ThingResourceManager.instance().validateAll();
    }

    static {
        ThingRegistries.staticInit();
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="jsonthings")
    public static class ClientHandlers {
        @SubscribeEvent
        public static void constructMod(FMLConstructModEvent event) {
            if (DatagenModLoader.isRunningDataGen()) {
                return;
            }
            event.enqueueWork(BlockColorHandler::init);
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, returnTo) -> {
                ThingResourceManager thingPackManager = ThingResourceManager.instance();
                return new PackSelectionScreen(thingPackManager.getRepository(), rpl -> {
                    Minecraft.getInstance().setScreen(returnTo);
                    thingPackManager.onConfigScreenSave();
                }, thingPackManager.getThingPacksLocation(), (Component)Component.literal((String)"Thing Packs"));
            });
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ResourceLocation solid = ResourceLocation.withDefaultNamespace((String)"solid");
            blockParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                ResourceLocation layer = thing.getDefaultRenderLayer();
                if (!layer.equals((Object)solid)) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((IFlexBlock)thing.get()).self(), (ChunkSectionLayer)NamedRenderTypeManager.get((ResourceLocation)layer).block());
                }
            });
            fluidParser.getBuilders().forEach(thing -> {
                if (thing.isInErrorState()) {
                    return;
                }
                ResourceLocation layer = thing.getDefaultRenderLayer();
                for (Fluid fluid : thing.getAllSiblings()) {
                    if (layer.equals((Object)solid)) continue;
                    ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (ChunkSectionLayer)NamedRenderTypeManager.get((ResourceLocation)layer).block());
                }
            });
        }

        @SubscribeEvent
        public static void blockColorHandlers(RegisterColorHandlersEvent.Block event) {
            blockParser.getBuilders().forEach(thing -> {
                String handlerName = thing.getColorHandler();
                if (handlerName != null) {
                    BlockColor bc = BlockColorHandler.get(handlerName);
                    event.register(bc, new Block[]{((IFlexBlock)thing.get()).self()});
                }
            });
        }

        @SubscribeEvent
        public static void clientProperties(RegisterClientExtensionsEvent event) {
            fluidTypeParser.getBuilders().forEach(thing -> {
                final Integer color = Objects.requireNonNullElse(thing.getColor(), -1);
                final ResourceLocation stillTexture = thing.getStillTexture();
                final ResourceLocation flowingTexture = thing.getFlowingTexture();
                final ResourceLocation sideTexture = thing.getSideTexture();
                event.registerFluidType(new IClientFluidTypeExtensions(){

                    public int getTintColor() {
                        return color;
                    }

                    public ResourceLocation getStillTexture() {
                        return stillTexture;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return flowingTexture;
                    }

                    @Nullable
                    public ResourceLocation getOverlayTexture() {
                        return sideTexture;
                    }
                }, new FluidType[]{(FluidType)thing.get()});
            });
        }
    }
}

