/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.events.FlexEventType;
import dev.gigaherz.jsonthings.things.events.IEventRunner;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.scripting.ScriptParser;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;

public abstract class BaseBuilder<T, B extends BaseBuilder<T, B>> {
    private final ThingParser<T, B> ownerParser;
    private final ResourceLocation registryName;
    private ResourceLocation parentBuilderName;
    private B parentBuilder;
    private T builtThing;
    private Map<String, List<ResourceLocation>> eventMap;
    private Throwable errorState = null;

    protected BaseBuilder(ThingParser<T, B> ownerParser, ResourceLocation registryName) {
        this.ownerParser = ownerParser;
        this.registryName = registryName;
    }

    public T build() {
        try {
            this.builtThing = this.buildInternal();
            return this.builtThing;
        }
        catch (Throwable t) {
            this.errorState = t;
            throw t;
        }
    }

    protected abstract String getThingTypeDisplayName();

    protected CrashReportCategory fillReport(CrashReport crashReport) {
        CrashReportCategory reportCategory = crashReport.addCategory("Thing", 1);
        reportCategory.setDetail("Resource name", (Object)this.registryName);
        return reportCategory;
    }

    protected abstract T buildInternal();

    public final T get() {
        if (this.builtThing == null) {
            return this.build();
        }
        if (this.errorState != null) {
            throw new IllegalStateException("This builder has previously errored due to " + this.errorState.getMessage(), this.errorState);
        }
        return this.builtThing;
    }

    public final boolean isInErrorState() {
        return this.errorState != null;
    }

    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    protected final ThingParser<T, B> getParser() {
        return this.ownerParser;
    }

    public void setParent(ResourceLocation parentBuilder) {
        this.parentBuilderName = parentBuilder;
    }

    public B requireParent() {
        if (this.parentBuilder == null) {
            if (this.parentBuilderName == null) {
                throw new IllegalStateException("Parent not set");
            }
            this.parentBuilder = (BaseBuilder)this.getParser().getBuildersMap().get(this.parentBuilderName);
            if (this.parentBuilder == null) {
                throw new IllegalStateException("The specified parent " + String.valueOf(this.parentBuilderName) + " is not a Json Things defined Block");
            }
        }
        return this.parentBuilder;
    }

    @Nullable
    public B getParent() {
        if (this.parentBuilderName == null) {
            return null;
        }
        if (this.parentBuilder == null) {
            this.parentBuilder = (BaseBuilder)this.getParser().getBuildersMap().get(this.parentBuilderName);
            if (this.parentBuilder == null) {
                this.parentBuilderName = null;
                return null;
            }
        }
        return this.parentBuilder;
    }

    @Nullable
    protected <V> V getValue(@Nullable V thisValue, Function<B, V> parentGetter) {
        return this.getValueOrElse(thisValue, parentGetter, null);
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    protected <V> V getValueOrElse(@Nullable V thisValue, Function<B, V> parentGetter, @Nullable V defaultValue) {
        if (thisValue != null) {
            return thisValue;
        }
        B parent = this.getParent();
        if (parent != null) {
            return parentGetter.apply(parent);
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    protected <V> V getValueOrElseGet(@Nullable V thisValue, Function<B, V> parentGetter, @Nullable Supplier<V> defaultValue) {
        if (thisValue != null) {
            return thisValue;
        }
        B parent = this.getParent();
        if (parent != null) {
            return parentGetter.apply(parent);
        }
        return defaultValue.get();
    }

    @Nullable
    protected final Map<String, List<ResourceLocation>> getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(Map<String, List<ResourceLocation>> eventMap) {
        this.eventMap = eventMap;
    }

    protected void forEachEvent(BiConsumer<String, List<ResourceLocation>> consumer) {
        B parent;
        Map<String, List<ResourceLocation>> ev = this.getEventMap();
        if (ev != null) {
            ev.forEach(consumer);
        }
        if ((parent = this.getParent()) != null) {
            ((BaseBuilder)parent).forEachEvent(consumer);
        }
    }

    protected void constructEventHandlers(IEventRunner eventRunner) {
        if (ScriptParser.isEnabled()) {
            this.forEachEvent((key, list) -> {
                FlexEventType<?> event = FlexEventType.byName(key);
                ThingParser.processAndConsumeErrors(this.getParser().getThingType(), list, ev -> eventRunner.addEventHandler(event, ScriptParser.instance().getEvent((ResourceLocation)ev)), unused -> this.getRegistryName());
            });
        }
    }

    public abstract void validate();
}

