/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.IBlockFactory;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BlockBuilder
extends BaseBuilder<IFlexBlock, BlockBuilder> {
    private List<Property<?>> properties;
    private Map<String, Property<?>> propertiesByName;
    private Map<String, String> propertyDefaultValues;
    private Map<Property<?>, Comparable<?>> propertyDefaultValuesMap;
    private FlexBlockType<?> blockType;
    private MapColor blockMaterialColor;
    private ItemBuilder itemBuilder;
    private DynamicShape generalShape;
    private DynamicShape collisionShape;
    private DynamicShape raytraceShape;
    private DynamicShape renderShape;
    private Boolean seeThrough;
    private String colorHandler;
    private Boolean requiresToolForDrops;
    private Boolean isAir;
    private Boolean hasCollision;
    private Boolean randomTicks;
    private Integer lightEmission;
    private Float explosionResistance;
    private Float destroyTime;
    private Float friction;
    private Float speedFactor;
    private Float jumpFactor;
    private ResourceLocation soundType;
    private Boolean blocksMotion;
    private Boolean ignitedByLava;
    private Boolean liquid;
    private Boolean replaceable;
    private Boolean forceSolid;
    private PushReaction pushReaction;
    private IBlockFactory<? extends Block> factory;

    public static BlockBuilder begin(ThingParser<IFlexBlock, BlockBuilder> ownerParser, ResourceLocation registryName) {
        return new BlockBuilder(ownerParser, registryName);
    }

    private BlockBuilder(ThingParser<IFlexBlock, BlockBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Block";
    }

    public void setBlockType(ResourceLocation typeName) {
        this.blockType = (FlexBlockType)ThingRegistries.BLOCK_TYPE.getOptional(typeName).orElseThrow(() -> new IllegalStateException("No known block type with name " + String.valueOf(typeName)));
    }

    public void setBlockType(FlexBlockType<?> type) {
        if (ThingRegistries.BLOCK_TYPE.getKey(type) == null) {
            throw new IllegalStateException("Block type not registered!");
        }
        this.blockType = type;
    }

    @Nullable
    public FlexBlockType<?> getBlockTypeRaw() {
        return this.getValue(this.blockType, BlockBuilder::getBlockTypeRaw);
    }

    public FlexBlockType<?> getBlockType() {
        return Utils.orElseGet(this.getBlockTypeRaw(), () -> FlexBlockType.PLAIN);
    }

    public boolean hasBlockType() {
        return this.getBlockTypeRaw() != null;
    }

    public void setItem(ItemBuilder itemBuilder) {
        this.itemBuilder = itemBuilder;
    }

    public void setProperties(Map<String, Property<?>> properties) {
        this.properties = properties.values().stream().toList();
        this.propertiesByName = properties;
    }

    @Nullable
    public List<Property<?>> getPropertiesRaw() {
        return this.getValue(this.properties, BlockBuilder::getPropertiesRaw);
    }

    public List<Property<?>> getProperties() {
        return Utils.orElseGet(this.getPropertiesRaw(), List::of);
    }

    public void setPropertyDefaultValue(String name, String value) {
        if (this.propertyDefaultValues == null) {
            this.propertyDefaultValues = new HashMap<String, String>();
        }
        this.propertyDefaultValues.put(name, value);
    }

    @Nullable
    public Map<String, String> getPropertyDefaultValuesRaw() {
        return this.getValue(this.propertyDefaultValues, BlockBuilder::getPropertyDefaultValuesRaw);
    }

    public Map<Property<?>, Comparable<?>> getPropertyDefaultValues() {
        if (this.propertyDefaultValuesMap == null) {
            Map<String, String> raw = this.getPropertyDefaultValuesRaw();
            this.propertyDefaultValuesMap = raw == null ? Map.of() : raw.entrySet().stream().map(e -> {
                Property<?> key = this.propertiesByName.get(e.getKey());
                Object value = Utils.getPropertyValue(key, (String)e.getValue());
                return Pair.of(key, value);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }
        return this.propertyDefaultValuesMap;
    }

    public void setMaterialColor(MapColor mapColor) {
        this.blockMaterialColor = mapColor;
    }

    @Nullable
    public MapColor getMaterialColor() {
        return this.getValue(this.blockMaterialColor, BlockBuilder::getMaterialColor);
    }

    public void setGeneralShape(DynamicShape shape) {
        this.generalShape = shape;
    }

    @Nullable
    public DynamicShape getGeneralShape() {
        return this.getValue(this.generalShape, BlockBuilder::getGeneralShape);
    }

    public void setCollisionShape(DynamicShape shape) {
        this.collisionShape = shape;
    }

    @Nullable
    public DynamicShape getCollisionShape() {
        return this.getValue(this.collisionShape, BlockBuilder::getCollisionShape);
    }

    public void setRaytraceShape(DynamicShape shape) {
        this.raytraceShape = shape;
    }

    @Nullable
    public DynamicShape getRaytraceShape() {
        return this.getValue(this.raytraceShape, BlockBuilder::getRaytraceShape);
    }

    public void setRenderShape(DynamicShape shape) {
        this.renderShape = shape;
    }

    @Nullable
    public DynamicShape getRenderShape() {
        return this.getValue(this.renderShape, BlockBuilder::getRenderShape);
    }

    public ResourceLocation getDefaultRenderLayer() {
        return ResourceLocation.parse((String)this.getBlockType().getDefaults().getDefaultLayer());
    }

    public void setColorHandler(String colorHandler) {
        this.colorHandler = colorHandler;
    }

    @Nullable
    public String getColorHandler() {
        return this.getValue(this.colorHandler, BlockBuilder::getColorHandler);
    }

    public void setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
    }

    @Nullable
    public Boolean isSeeThrough() {
        return this.getValue(this.seeThrough, BlockBuilder::isSeeThrough);
    }

    public void setRequiresToolForDrops(boolean requiresToolForDrops) {
        this.requiresToolForDrops = requiresToolForDrops;
    }

    @Nullable
    public Boolean requiresToolForDrops() {
        return this.getValue(this.requiresToolForDrops, BlockBuilder::requiresToolForDrops);
    }

    public void setIsAir(boolean isAir) {
        this.isAir = isAir;
    }

    @Nullable
    public Boolean getIsAir() {
        return this.getValue(this.isAir, BlockBuilder::getIsAir);
    }

    public void setHasCollision(boolean hasCollision) {
        this.hasCollision = hasCollision;
    }

    @Nullable
    public Boolean getHasCollision() {
        return this.getValue(this.hasCollision, BlockBuilder::getHasCollision);
    }

    public void setTicksRandom(boolean randomTicks) {
        this.randomTicks = randomTicks;
    }

    @Nullable
    public Boolean getTicksRandom() {
        return this.getValue(this.randomTicks, BlockBuilder::getTicksRandom);
    }

    public void setLightEmission(int lightEmission) {
        this.lightEmission = lightEmission;
    }

    @Nullable
    public Integer getLightEmission() {
        return this.getValue(this.lightEmission, BlockBuilder::getLightEmission);
    }

    public void setExplosionResistance(float explosionResistance) {
        this.explosionResistance = Float.valueOf(explosionResistance);
    }

    @Nullable
    public Float getExplosionResistance() {
        return this.getValue(this.explosionResistance, BlockBuilder::getExplosionResistance);
    }

    public void setDestroyTime(float destroyTime) {
        this.destroyTime = Float.valueOf(destroyTime);
    }

    @Nullable
    public Float getDestroyTime() {
        return this.getValue(this.destroyTime, BlockBuilder::getDestroyTime);
    }

    public void setFriction(float friction) {
        this.friction = Float.valueOf(friction);
    }

    @Nullable
    public Float getFriction() {
        return this.getValue(this.friction, BlockBuilder::getFriction);
    }

    public void setSpeedFactor(float speedFactor) {
        this.speedFactor = Float.valueOf(speedFactor);
    }

    @Nullable
    public Float getSpeedFactor() {
        return this.getValue(this.speedFactor, BlockBuilder::getSpeedFactor);
    }

    public void setJumpFactor(float jumpFactor) {
        this.jumpFactor = Float.valueOf(jumpFactor);
    }

    @Nullable
    public Float getJumpFactor() {
        return this.getValue(this.jumpFactor, BlockBuilder::getJumpFactor);
    }

    public void setSoundType(ResourceLocation loc) {
        this.soundType = loc;
    }

    @Nullable
    public ResourceLocation getSoundType() {
        return this.getValue(this.soundType, BlockBuilder::getSoundType);
    }

    public void setPushReaction(PushReaction pushReaction) {
        this.pushReaction = pushReaction;
    }

    @Nullable
    public PushReaction getPushReaction() {
        return this.getValue(this.pushReaction, BlockBuilder::getPushReaction);
    }

    public void setBlocksMotion(boolean blocksMotion) {
        this.blocksMotion = blocksMotion;
    }

    @Nullable
    public Boolean getBlocksMotion() {
        return this.getValue(this.blocksMotion, BlockBuilder::getBlocksMotion);
    }

    public void setIgnitedByLava(boolean ignitedByLava) {
        this.ignitedByLava = ignitedByLava;
    }

    @Nullable
    public Boolean getIgnitedByLava() {
        return this.getValue(this.ignitedByLava, BlockBuilder::getIgnitedByLava);
    }

    public void setReplaceable(boolean replaceable) {
        this.replaceable = replaceable;
    }

    @Nullable
    public Boolean getReplaceable() {
        return this.getValue(this.replaceable, BlockBuilder::getReplaceable);
    }

    public void setForceSolid(boolean solid) {
        this.forceSolid = solid;
    }

    @Nullable
    public Boolean getForceSolid() {
        return this.getValue(this.forceSolid, BlockBuilder::getForceSolid);
    }

    @Override
    protected IFlexBlock buildInternal() {
        MapColor blockMaterialColor = this.getMaterialColor();
        BlockBehaviour.Properties props = BlockBehaviour.Properties.of();
        props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)this.getRegistryName()));
        FlexBlockType<?> blockType = this.getBlockType();
        if (blockMaterialColor != null) {
            props.mapColor(blockMaterialColor);
        }
        if (Utils.orElse(this.isSeeThrough(), blockType.getDefaults().isDefaultSeeThrough()).booleanValue()) {
            props.noOcclusion();
        }
        if (Utils.orElse(this.requiresToolForDrops(), false).booleanValue()) {
            props.requiresCorrectToolForDrops();
        }
        if (Utils.orElse(this.getIsAir(), false).booleanValue()) {
            props.air();
        }
        if (!Utils.orElse(this.getHasCollision(), true).booleanValue()) {
            props.noCollision();
        }
        if (Utils.orElse(this.getTicksRandom(), blockType.getDefaults().isDefaultTicksRandomly()).booleanValue()) {
            props.randomTicks();
        }
        if (Utils.orElse(this.getLightEmission(), 0) > 0) {
            props.lightLevel(state -> this.getLightEmission());
        }
        if (Utils.orElse(this.getExplosionResistance(), Float.valueOf(0.0f)).floatValue() > 0.0f) {
            props.explosionResistance(this.getExplosionResistance().floatValue());
        }
        if (Utils.orElse(this.getDestroyTime(), Float.valueOf(0.0f)).floatValue() > 0.0f) {
            props.destroyTime(this.getDestroyTime().floatValue());
        }
        if (Utils.orElse(this.getFriction(), Float.valueOf(0.6f)).floatValue() != 0.6f) {
            props.friction(this.getFriction().floatValue());
        }
        if (Utils.orElse(this.getSpeedFactor(), Float.valueOf(1.0f)).floatValue() != 1.0f) {
            props.speedFactor(this.getSpeedFactor().floatValue());
        }
        if (Utils.orElse(this.getJumpFactor(), Float.valueOf(1.0f)).floatValue() != 1.0f) {
            props.jumpFactor(this.getSpeedFactor().floatValue());
        }
        if (Utils.orElse(this.getPushReaction(), PushReaction.NORMAL) != PushReaction.NORMAL) {
            props.pushReaction(this.getPushReaction());
        }
        if (Utils.orElse(this.getIgnitedByLava(), blockType.getDefaults().isDefaultIgnitedByLava()).booleanValue()) {
            props.ignitedByLava();
        }
        if (Utils.orElse(this.getReplaceable(), blockType.getDefaults().isDefaultReplaceable()).booleanValue()) {
            props.replaceable();
        }
        if (Utils.orElse(this.getForceSolid(), false).booleanValue()) {
            props.forceSolidOn();
        }
        if (!Utils.orElse(this.getBlocksMotion(), true).booleanValue()) {
            props.forceSolidOff();
        }
        if (this.getSoundType() != null) {
            props.sound(Utils.getOrCrash(ThingRegistries.SOUND_TYPE, this.getSoundType()));
        }
        List<Property<?>> stockProperties = blockType.getDefaults().getStockProperties();
        List<Property<?>> properties = this.getProperties();
        List<Property> badProperties = properties.stream().filter(prop -> {
            for (Property p : stockProperties) {
                if (p == prop || !p.getName().equals(prop.getName())) continue;
                return true;
            }
            return false;
        }).toList();
        if (badProperties.size() > 0) {
            throw new IllegalStateException("The block of type " + String.valueOf(blockType) + " cannot define non-duplicate properties with clashing names: " + badProperties.stream().map(Property::getName).collect(Collectors.joining(" ")));
        }
        IFlexBlock flexBlock = (IFlexBlock)this.factory.construct(props, this);
        flexBlock.setGeneralShape(this.getGeneralShape());
        flexBlock.setCollisionShape(this.getCollisionShape());
        flexBlock.setRaytraceShape(this.getRaytraceShape());
        flexBlock.setRenderShape(this.getRenderShape());
        this.constructEventHandlers(flexBlock);
        return flexBlock;
    }

    public Map<String, Property<?>> getPropertiesByName() {
        return Collections.unmodifiableMap(this.propertiesByName);
    }

    @Nullable
    public ItemBuilder getItemBuilder() {
        return this.itemBuilder;
    }

    public void setFactory(IBlockFactory<?> factory) {
        this.factory = factory;
    }

    @Override
    public void validate() {
    }
}

