/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class BlockSetTypeBuilder
extends BaseBuilder<BlockSetType, BlockSetTypeBuilder> {
    private ResourceLocation soundType;
    private ResourceLocation doorClose;
    private ResourceLocation doorOpen;
    private ResourceLocation trapdoorClose;
    private ResourceLocation trapdoorOpen;
    private ResourceLocation pressurePlateOff;
    private ResourceLocation pressurePlateOn;
    private ResourceLocation buttonOff;
    private ResourceLocation buttonOn;
    private boolean isWood;
    private ResourceLocation hangingSignSoundType;
    private ResourceLocation fenceGateClose;
    private ResourceLocation fenceGateOpen;
    private boolean canOpenByHand = true;
    private boolean canOpenByWindCharge = true;
    private boolean canButtonBeActivatedByArrows = true;
    private BlockSetType.PressurePlateSensitivity pressurePlateSensitivity = BlockSetType.PressurePlateSensitivity.EVERYTHING;

    public static BlockSetTypeBuilder begin(ThingParser<BlockSetType, BlockSetTypeBuilder> ownerParser, ResourceLocation registryName) {
        return new BlockSetTypeBuilder(ownerParser, registryName);
    }

    private BlockSetTypeBuilder(ThingParser<BlockSetType, BlockSetTypeBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    public void setSoundType(ResourceLocation resourceLocation) {
        this.soundType = resourceLocation;
    }

    public void setDoorClose(ResourceLocation resourceLocation) {
        this.doorClose = resourceLocation;
    }

    public void setDoorOpen(ResourceLocation resourceLocation) {
        this.doorOpen = resourceLocation;
    }

    public void setTrapdoorClose(ResourceLocation resourceLocation) {
        this.trapdoorClose = resourceLocation;
    }

    public void setTrapdoorOpen(ResourceLocation resourceLocation) {
        this.trapdoorOpen = resourceLocation;
    }

    public void setPressurePlateOff(ResourceLocation resourceLocation) {
        this.pressurePlateOff = resourceLocation;
    }

    public void setPressurePlateOn(ResourceLocation resourceLocation) {
        this.pressurePlateOn = resourceLocation;
    }

    public void setButtonOff(ResourceLocation resourceLocation) {
        this.buttonOff = resourceLocation;
    }

    public void setButtonOn(ResourceLocation resourceLocation) {
        this.buttonOn = resourceLocation;
    }

    public void setIsWood(boolean b) {
        this.isWood = b;
    }

    public void setHangingSignSoundType(ResourceLocation resourceLocation) {
        this.hangingSignSoundType = resourceLocation;
    }

    public void setFenceGateClose(ResourceLocation resourceLocation) {
        this.fenceGateClose = resourceLocation;
    }

    public void setFenceGateOpen(ResourceLocation resourceLocation) {
        this.fenceGateOpen = resourceLocation;
    }

    public void setCanOpenByHand(boolean b) {
        this.canOpenByHand = b;
    }

    public void setCanOpenByWindCharge(boolean b) {
        this.canOpenByWindCharge = b;
    }

    public void setCanButtonBeActivatedByArrowsd(boolean b) {
        this.canButtonBeActivatedByArrows = b;
    }

    public void setPressurePlateSensitivity(BlockSetType.PressurePlateSensitivity sensitivity) {
        this.pressurePlateSensitivity = sensitivity;
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Block Set Type";
    }

    @Override
    protected BlockSetType buildInternal() {
        SoundType soundTypeObj = Utils.getOrElse(ThingRegistries.SOUND_TYPE, this.soundType, SoundType.WOOD);
        SoundEvent doorCloseEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.doorClose, SoundEvents.WOODEN_DOOR_CLOSE);
        SoundEvent doorOpenEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.doorOpen, SoundEvents.WOODEN_DOOR_OPEN);
        SoundEvent trapdoorCloseEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.trapdoorClose, SoundEvents.WOODEN_TRAPDOOR_CLOSE);
        SoundEvent trapdoorOpenEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.trapdoorOpen, SoundEvents.WOODEN_TRAPDOOR_OPEN);
        SoundEvent pressurePlateOffEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.pressurePlateOff, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF);
        SoundEvent pressurePlateOnEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.pressurePlateOn, SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_ON);
        SoundEvent buttonOffEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.buttonOff, SoundEvents.WOODEN_BUTTON_CLICK_OFF);
        SoundEvent buttonOnEvent = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.buttonOn, SoundEvents.WOODEN_BUTTON_CLICK_ON);
        return new BlockSetType(this.getRegistryName().toString(), this.canOpenByHand, this.canOpenByWindCharge, this.canButtonBeActivatedByArrows, this.pressurePlateSensitivity, soundTypeObj, doorCloseEvent, doorOpenEvent, trapdoorCloseEvent, trapdoorOpenEvent, pressurePlateOffEvent, pressurePlateOnEvent, buttonOffEvent, buttonOnEvent);
    }

    public boolean isWood() {
        return this.isWood;
    }

    public WoodType buildWoodType(BlockSetType setType) {
        SoundType hangingSignSoundType = Utils.getOrElse(ThingRegistries.SOUND_TYPE, this.pressurePlateOn, SoundType.HANGING_SIGN);
        SoundEvent fenceGateClose = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.fenceGateClose, SoundEvents.FENCE_GATE_CLOSE);
        SoundEvent fenceGateOpen = Utils.getOrElse(BuiltInRegistries.SOUND_EVENT, this.fenceGateOpen, SoundEvents.FENCE_GATE_OPEN);
        return new WoodType(this.getRegistryName().toString(), setType, setType.soundType(), hangingSignSoundType, fenceGateClose, fenceGateOpen);
    }

    @Override
    public void validate() {
    }
}

