/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexCreativeModeTab;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.DelayedVariantProvider;
import dev.gigaherz.jsonthings.things.serializers.ItemVariantProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public class CreativeModeTabBuilder
extends BaseBuilder<FlexCreativeModeTab, CreativeModeTabBuilder> {
    private StackContext iconItem;
    private final ArrayList<ItemVariantProvider> items = new ArrayList();
    private ResourceLocation[] before;
    private ResourceLocation[] after;
    private String translation_key;
    private boolean rightSide;

    public static CreativeModeTabBuilder begin(ThingParser<FlexCreativeModeTab, CreativeModeTabBuilder> ownerParser, ResourceLocation registryName) {
        return new CreativeModeTabBuilder(ownerParser, registryName);
    }

    private CreativeModeTabBuilder(ThingParser<FlexCreativeModeTab, CreativeModeTabBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Creative Mode Tab";
    }

    public void setIcon(StackContext stackContext) {
        this.iconItem = stackContext;
    }

    public void setBefore(ResourceLocation ... before) {
        this.before = before;
    }

    public void setAfter(ResourceLocation ... after) {
        this.after = after;
    }

    public void setTranslationKey(String key) {
        this.translation_key = key;
    }

    public void setRightSide(boolean rightSide) {
        this.rightSide = rightSide;
    }

    @Override
    protected FlexCreativeModeTab buildInternal() {
        ResourceLocation registryName = this.getRegistryName();
        return new FlexCreativeModeTab((String)(this.translation_key != null ? this.translation_key : registryName.getNamespace() + "." + registryName.getPath().replace("/", ".")), this.iconItem);
    }

    public void addItem(ResourceLocation item) {
        this.items.add(new DelayedVariantProvider(item));
    }

    public void addItem(StackContext stackContext) {
        this.items.add(stackContext);
    }

    public List<ItemVariantProvider> getVariantProviders() {
        return this.items;
    }

    public CreativeModeTab buildTab(FlexCreativeModeTab tab) {
        StackContext icon = tab.icon();
        String name = tab.name();
        CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).icon(() -> icon.toStack(null)).title((Component)Component.translatable((String)name)).displayItems((parameters, output) -> {
            for (ItemVariantProvider variantProvider : this.getVariantProviders()) {
                variantProvider.provideVariants((ResourceKey<CreativeModeTab>)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)this.getRegistryName()), output, parameters, null, true);
            }
        });
        if (this.getBefore() != null) {
            builder = builder.withTabsAfter(this.getBefore());
        }
        if (this.getAfter() != null) {
            builder = builder.withTabsBefore(this.getAfter());
        }
        if (this.getRightSide()) {
            builder = builder.alignedRight();
        }
        return builder.build();
    }

    public ResourceLocation @Nullable [] getBefore() {
        return this.before;
    }

    public ResourceLocation @Nullable [] getAfter() {
        return this.after;
    }

    public boolean getRightSide() {
        return this.rightSide;
    }

    @Override
    public void validate() {
    }
}

