/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexFluidType;
import dev.gigaherz.jsonthings.things.serializers.IFluidFactory;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidType;

public class FluidBuilder
extends BaseBuilder<IFlexFluid, FluidBuilder> {
    private FlexFluidType<?> fluidType;
    private List<Property<?>> properties;
    private Map<String, Property<?>> propertiesByName;
    private Map<String, String> propertyDefaultValues;
    private Map<Property<?>, Comparable<?>> propertyDefaultValuesMap;
    private ItemBuilder itemBuilder;
    private Supplier<FluidType> attributesType;
    private IFluidFactory<? extends Fluid> factory;

    public static FluidBuilder begin(ThingParser<IFlexFluid, FluidBuilder> ownerParser, ResourceLocation registryName) {
        return new FluidBuilder(ownerParser, registryName);
    }

    private FluidBuilder(ThingParser<IFlexFluid, FluidBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Fluid";
    }

    public void setFluidType(ResourceLocation typeName) {
        this.fluidType = (FlexFluidType)ThingRegistries.FLUID_TYPE.getOptional(typeName).orElseThrow(() -> new IllegalStateException("No known Fluid type with name " + String.valueOf(typeName)));
    }

    public void setBucket(ItemBuilder itemBuilder) {
        this.itemBuilder = itemBuilder;
    }

    public void setProperties(Map<String, Property<?>> properties) {
        this.properties = properties.values().stream().toList();
        this.propertiesByName = properties;
    }

    public void setPropertyDefaultValue(String name, String value) {
        if (this.propertyDefaultValues == null) {
            this.propertyDefaultValues = new HashMap<String, String>();
        }
        this.propertyDefaultValues.put(name, value);
    }

    public void setAttributesType(Supplier<FluidType> attributesType) {
        this.attributesType = attributesType;
    }

    @Override
    protected IFlexFluid buildInternal() {
        FlexFluidType<?> fluidType = this.getFluidType();
        List<Property<?>> stockProperties = fluidType.getStockProperties();
        List<Property<?>> properties = this.getProperties();
        List<Property> badProperties = properties.stream().filter(prop -> {
            for (Property p : stockProperties) {
                if (p == prop || !p.getName().equals(prop.getName())) continue;
                return true;
            }
            return false;
        }).toList();
        if (badProperties.size() > 0) {
            throw new IllegalStateException("The fluid of type " + String.valueOf(fluidType) + " cannot define non-duplicate properties with clashing names: " + badProperties.stream().map(Property::getName).collect(Collectors.joining(" ")));
        }
        IFlexFluid flexFluid = (IFlexFluid)this.factory.construct(this);
        if (this.getBucketBuilder() != null) {
            flexFluid.setBucketItem((Supplier<Item>)Lazy.of(() -> (Item)this.getBucketBuilder().get()));
        }
        this.constructEventHandlers(flexFluid);
        return flexFluid;
    }

    @Nullable
    public FlexFluidType<?> getFluidTypeRaw() {
        return this.getValue(this.fluidType, FluidBuilder::getFluidTypeRaw);
    }

    public FlexFluidType<?> getFluidType() {
        return Utils.orElseGet(this.getFluidTypeRaw(), () -> FlexFluidType.PLAIN);
    }

    @Nullable
    public List<Property<?>> getPropertiesRaw() {
        return this.getValue(this.properties, FluidBuilder::getPropertiesRaw);
    }

    public List<Property<?>> getProperties() {
        return Utils.orElseGet(this.getPropertiesRaw(), List::of);
    }

    @Nullable
    public Map<String, String> getPropertyDefaultValuesRaw() {
        return this.getValue(this.propertyDefaultValues, FluidBuilder::getPropertyDefaultValuesRaw);
    }

    public Map<Property<?>, Comparable<?>> getPropertyDefaultValues() {
        if (this.propertyDefaultValuesMap == null) {
            Map<String, String> raw = this.getPropertyDefaultValuesRaw();
            this.propertyDefaultValuesMap = raw == null ? Map.of() : raw.entrySet().stream().map(e -> {
                Property<?> key = this.propertiesByName.get(e.getKey());
                Object value = Utils.getPropertyValue(key, (String)e.getValue());
                return Pair.of(key, value);
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        }
        return this.propertyDefaultValuesMap;
    }

    public Map<String, Property<?>> getPropertiesByName() {
        return Collections.unmodifiableMap(this.propertiesByName);
    }

    @Nullable
    public ItemBuilder getBucketBuilder() {
        return this.itemBuilder;
    }

    public Supplier<FluidType> getAttributesType() {
        Supplier val = this.getValue(this.attributesType, FluidBuilder::getAttributesType);
        if (val == null) {
            throw new IllegalStateException("fluid_type not set!");
        }
        return val;
    }

    public ResourceLocation getDefaultRenderLayer() {
        return ResourceLocation.parse((String)this.getFluidType().getDefaultLayer());
    }

    public void register(BiConsumer<ResourceLocation, Fluid> register) {
        if (this.isInErrorState()) {
            return;
        }
        this.get();
        this.factory.register(this, register);
    }

    public void setFactory(IFluidFactory<?> factory) {
        this.factory = factory;
    }

    public Iterable<Fluid> getAllSiblings() {
        return this.factory.getAllSiblings(this);
    }

    @Override
    public void validate() {
    }
}

