/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Rarity;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class FluidTypeBuilder
extends BaseBuilder<FluidType, FluidTypeBuilder> {
    private ResourceLocation stillTexture;
    private ResourceLocation flowingTexture;
    private ResourceLocation sideTexture;
    private Rarity rarity = Rarity.COMMON;
    private Integer color;
    private Integer density;
    private Integer lightLevel;
    private Integer temperature;
    private Integer viscosity;
    private String translationKey;
    private Boolean isGaseous;
    private ResourceLocation fillSound;
    private ResourceLocation emptySound;
    private ResourceLocation vaporizeSound;
    private Double motionScale;
    private Float fallDistanceModifier;
    private Boolean canPushEntity;
    private Boolean canSwim;
    private Boolean canDrown;
    private Boolean canExtinguish;
    private Boolean canHydrate;
    private Boolean canConvertToSource;
    private Boolean supportsBoating;

    public static FluidTypeBuilder begin(ThingParser<FluidType, FluidTypeBuilder> ownerParser, ResourceLocation registryName) {
        return new FluidTypeBuilder(ownerParser, registryName);
    }

    private FluidTypeBuilder(ThingParser<FluidType, FluidTypeBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Fluid";
    }

    public void setStillTexture(ResourceLocation stillTexture) {
        this.stillTexture = stillTexture;
    }

    @Nullable
    public ResourceLocation getStillTexture() {
        return this.getValue(this.stillTexture, FluidTypeBuilder::getStillTexture);
    }

    public void setFlowingTexture(ResourceLocation flowingTexture) {
        this.flowingTexture = flowingTexture;
    }

    @Nullable
    public ResourceLocation getFlowingTexture() {
        return this.getValue(this.flowingTexture, FluidTypeBuilder::getFlowingTexture);
    }

    public void setSideTexture(ResourceLocation overlay) {
        this.sideTexture = overlay;
    }

    @Nullable
    public ResourceLocation getSideTexture() {
        return this.getValue(this.sideTexture, FluidTypeBuilder::getSideTexture);
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    @Nullable
    private Rarity getRarity() {
        return this.getValue(this.rarity, FluidTypeBuilder::getRarity);
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    @Nullable
    public Integer getColor() {
        return this.getValue(this.color, FluidTypeBuilder::getColor);
    }

    public void setDensity(Integer density) {
        this.density = density;
    }

    @Nullable
    private Integer getDensity() {
        return this.getValue(this.density, FluidTypeBuilder::getDensity);
    }

    public void setLightLevel(Integer lightLevel) {
        this.lightLevel = lightLevel;
    }

    @Nullable
    private Integer getLightLevel() {
        return this.getValue(this.lightLevel, FluidTypeBuilder::getLightLevel);
    }

    public void setTemperature(Integer temperature) {
        this.temperature = temperature;
    }

    @Nullable
    private Integer getTemperature() {
        return this.getValue(this.temperature, FluidTypeBuilder::getTemperature);
    }

    public void setViscosity(Integer viscosity) {
        this.viscosity = viscosity;
    }

    @Nullable
    private Integer getViscosity() {
        return this.getValue(this.viscosity, FluidTypeBuilder::getViscosity);
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    @Nullable
    private String getTranslationKey() {
        return this.getValue(this.translationKey, FluidTypeBuilder::getTranslationKey);
    }

    public void setGaseous(Boolean gaseous) {
        this.isGaseous = gaseous;
    }

    @Nullable
    private Boolean getIsGaseous() {
        return this.getValue(this.isGaseous, FluidTypeBuilder::getIsGaseous);
    }

    public void setFillSound(ResourceLocation fillSound) {
        this.fillSound = fillSound;
    }

    @Nullable
    private ResourceLocation getFillSound() {
        return this.getValue(this.fillSound, FluidTypeBuilder::getFillSound);
    }

    public void setEmptySound(ResourceLocation emptySound) {
        this.emptySound = emptySound;
    }

    @Nullable
    private ResourceLocation getEmptySound() {
        return this.getValue(this.emptySound, FluidTypeBuilder::getEmptySound);
    }

    public void setVaporizeSound(ResourceLocation vaporizeSound) {
        this.vaporizeSound = vaporizeSound;
    }

    @Nullable
    private ResourceLocation getVaporizeSound() {
        return this.getValue(this.vaporizeSound, FluidTypeBuilder::getVaporizeSound);
    }

    public void setMotionScale(double motionScale) {
        this.motionScale = motionScale;
    }

    @Nullable
    public Double getMotionScale() {
        return this.getValue(this.motionScale, FluidTypeBuilder::getMotionScale);
    }

    public void setFallDistanceModifier(float fallDistanceModifier) {
        this.fallDistanceModifier = Float.valueOf(fallDistanceModifier);
    }

    @Nullable
    public Float getFallDistanceModifier() {
        return this.getValue(this.fallDistanceModifier, FluidTypeBuilder::getFallDistanceModifier);
    }

    public void setCanPushEntity(boolean canPushEntity) {
        this.canPushEntity = canPushEntity;
    }

    @Nullable
    public Boolean getCanPushEntity() {
        return this.getValue(this.canPushEntity, FluidTypeBuilder::getCanPushEntity);
    }

    public void setCanSwim(boolean canSwim) {
        this.canSwim = canSwim;
    }

    @Nullable
    public Boolean getCanSwim() {
        return this.getValue(this.canSwim, FluidTypeBuilder::getCanSwim);
    }

    public void setCanDrown(boolean canDrown) {
        this.canDrown = canDrown;
    }

    @Nullable
    public Boolean getCanDrown() {
        return this.getValue(this.canDrown, FluidTypeBuilder::getCanDrown);
    }

    public void setCanExtinguish(boolean canExtinguish) {
        this.canExtinguish = canExtinguish;
    }

    @Nullable
    public Boolean getCanExtinguish() {
        return this.getValue(this.canExtinguish, FluidTypeBuilder::getCanExtinguish);
    }

    public void setCanHydrate(boolean canHydrate) {
        this.canHydrate = canHydrate;
    }

    @Nullable
    public Boolean getCanHydrate() {
        return this.getValue(this.canHydrate, FluidTypeBuilder::getCanHydrate);
    }

    public void setCanConvertToSource(boolean canConvertToSource) {
        this.canConvertToSource = canConvertToSource;
    }

    @Nullable
    public Boolean getCanConvertToSource() {
        return this.getValue(this.canConvertToSource, FluidTypeBuilder::getCanConvertToSource);
    }

    public void setSupportsBoating(boolean supportsBoating) {
        this.supportsBoating = supportsBoating;
    }

    @Nullable
    public Boolean getSupportsBoating() {
        return this.getValue(this.supportsBoating, FluidTypeBuilder::getSupportsBoating);
    }

    @Override
    protected FluidType buildInternal() {
        SoundEvent vaporizeSound;
        SoundEvent emptySound;
        SoundEvent fillSound;
        FluidType.Properties props = FluidType.Properties.create();
        if (this.getLightLevel() != null) {
            props.lightLevel(this.getLightLevel().intValue());
        }
        if (this.getDensity() != null) {
            props.density(this.getDensity().intValue());
        }
        if (this.getTemperature() != null) {
            props.temperature(this.getTemperature().intValue());
        }
        if (this.getViscosity() != null) {
            props.viscosity(this.getViscosity().intValue());
        }
        if (this.getRarity() != null) {
            props.rarity(this.getRarity());
        }
        SoundEvent soundEvent = fillSound = this.getFillSound() != null ? (SoundEvent)Utils.getOrCrash(BuiltInRegistries.SOUND_EVENT, this.getFillSound()) : null;
        if (fillSound != null) {
            props.sound(SoundActions.BUCKET_FILL, fillSound);
        }
        SoundEvent soundEvent2 = emptySound = this.getEmptySound() != null ? (SoundEvent)Utils.getOrCrash(BuiltInRegistries.SOUND_EVENT, this.getEmptySound()) : null;
        if (emptySound != null) {
            props.sound(SoundActions.BUCKET_EMPTY, emptySound);
        }
        SoundEvent soundEvent3 = vaporizeSound = this.getVaporizeSound() != null ? (SoundEvent)Utils.getOrCrash(BuiltInRegistries.SOUND_EVENT, this.getVaporizeSound()) : null;
        if (vaporizeSound != null) {
            props.sound(SoundActions.FLUID_VAPORIZE, emptySound);
        }
        if (this.getTranslationKey() != null) {
            props.descriptionId(this.getTranslationKey());
        }
        if (this.getMotionScale() != null) {
            props.motionScale(this.getMotionScale().doubleValue());
        }
        if (this.getFallDistanceModifier() != null) {
            props.fallDistanceModifier(this.getFallDistanceModifier().floatValue());
        }
        if (this.getCanPushEntity() != null) {
            props.canPushEntity(this.getCanPushEntity().booleanValue());
        }
        if (this.getCanSwim() != null) {
            props.canSwim(this.getCanSwim().booleanValue());
        }
        if (this.getCanDrown() != null) {
            props.canDrown(this.getCanDrown().booleanValue());
        }
        if (this.getCanExtinguish() != null) {
            props.canExtinguish(this.getCanExtinguish().booleanValue());
        }
        if (this.getCanConvertToSource() != null) {
            props.canConvertToSource(this.getCanConvertToSource().booleanValue());
        }
        if (this.getCanHydrate() != null) {
            props.canHydrate(this.getCanHydrate().booleanValue());
        }
        if (this.getSupportsBoating() != null) {
            props.supportsBoating(this.getSupportsBoating().booleanValue());
        }
        int color = this.getColor() != null ? this.getColor() : -1;
        ResourceLocation stillTexture = this.getStillTexture();
        ResourceLocation flowingTexture = this.getFlowingTexture();
        ResourceLocation sideTexture = this.getSideTexture();
        if (stillTexture == null) {
            throw new IllegalStateException("FluidType requires a still_texture value");
        }
        if (flowingTexture == null) {
            throw new IllegalStateException("FluidType requires a flowing_texture value");
        }
        return new FluidType(props);
    }

    @Override
    public void validate() {
    }
}

