/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockColorHandler {
    private static final Map<String, BlockColor> colorHandlersByName = Maps.newHashMap();

    public static void init() {
        BlockColorHandler.register("tall_grass", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)reader, (BlockPos)(state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos)) : -1);
        BlockColorHandler.register("grass", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0));
        BlockColorHandler.register("spruce", (state, reader, pos, color) -> -10380959);
        BlockColorHandler.register("birch", (state, reader, pos, color) -> -8345771);
        BlockColorHandler.register("mangrove", (state, reader, pos, color) -> -7158200);
        BlockColorHandler.register("foliage", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)reader, (BlockPos)pos) : -12012264);
        BlockColorHandler.register("water", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)reader, (BlockPos)pos) : -1);
        BlockColorHandler.register("redstone", (state, reader, pos, color) -> RedStoneWireBlock.getColorForPower((int)((Integer)state.getValue((Property)RedStoneWireBlock.POWER))));
        BlockColorHandler.register("sugarcane", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)reader, (BlockPos)pos) : -1);
    }

    public static void register(String name, BlockColor handler) {
        colorHandlersByName.put(name, handler);
    }

    public static BlockColor get(String handlerName) {
        if (!colorHandlersByName.containsKey(handlerName)) {
            throw new IllegalStateException("No block color handler known with name " + handlerName);
        }
        return colorHandlersByName.get(handlerName);
    }
}

