/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.fluids;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;

public class FlexFlowingFluid
extends FlowingFluid
implements IFlexFluid {
    private final Fluid flowing;
    private final int slopeDistance;
    private final int dropOff;
    private final boolean canConvertToSource;
    private final int tickDelay;
    private final float explosionResistance;
    private final Supplier<Block> block;
    private final Map<FlexEventType, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private Supplier<Item> bucketItem = () -> Items.AIR;
    private Supplier<FluidType> fluidType;

    public FlexFlowingFluid(Supplier<FluidType> fluidType, final List<Property<?>> properties, Map<Property<?>, Comparable<?>> propertyDefaultValues, int slopeDistance, int dropOff, boolean canConvertToSource, int tickDelay, float explosionResistance, Supplier<Block> block) {
        this.fluidType = fluidType;
        this.slopeDistance = slopeDistance;
        this.dropOff = dropOff;
        this.canConvertToSource = canConvertToSource;
        this.tickDelay = tickDelay;
        this.explosionResistance = explosionResistance;
        this.block = block;
        this.initializeFlex(propertyDefaultValues);
        this.flowing = new Flowing(this, this, propertyDefaultValues){

            @Override
            protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder1) {
                super.createFluidStateDefinition(builder1);
                properties.forEach(xva$0 -> builder1.add(new Property[]{xva$0}));
            }
        };
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (propertyDefaultValues.size() > 0) {
            FluidState def = (FluidState)this.getStateDefinition().any();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (FluidState)def.setValue(prop, value);
            }
            this.registerDefaultState(def);
        }
    }

    @Override
    public <T> void addEventHandler(FlexEventType<T> event, FlexEventHandler<T> eventHandler) {
        this.eventHandlers.put(event, eventHandler);
    }

    @Override
    public <T> FlexEventHandler<T> getEventHandler(FlexEventType<T> event) {
        return this.eventHandlers.get(event);
    }

    @Override
    public void setBucketItem(Supplier<Item> bucketItem) {
        this.bucketItem = bucketItem;
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }

    public Item getBucket() {
        return this.bucketItem != null ? this.bucketItem.get() : Items.AIR;
    }

    public boolean isSame(Fluid pFluid) {
        return pFluid == this.getSource() || pFluid == this.getFlowing();
    }

    protected boolean canBeReplacedWith(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
        return pDirection == Direction.DOWN && !this.isSame(pFluid);
    }

    public int getTickDelay(LevelReader level) {
        return this.tickDelay;
    }

    protected float getExplosionResistance() {
        return this.explosionResistance;
    }

    public BlockState createLegacyBlock(FluidState pState) {
        Block b = this.block.get();
        if (b == Blocks.AIR) {
            return b.defaultBlockState();
        }
        return (BlockState)b.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(FlexFlowingFluid.getLegacyLevel((FluidState)pState)));
    }

    public int getAmount(FluidState state) {
        return 8;
    }

    public boolean isSource(FluidState state) {
        return true;
    }

    public Fluid getFlowing() {
        return this.flowing;
    }

    public Fluid getSource() {
        return this;
    }

    protected boolean canConvertToSource(ServerLevel level) {
        return this.canConvertToSource;
    }

    protected void beforeDestroyingBlock(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        InteractionResult.Pass result = InteractionResult.PASS;
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            result = (InteractionResult)this.runEvent(FlexEventType.BEFORE_DESTROY, FlexEventContext.of(level, pPos, pState), () -> InteractionResult.PASS);
        }
        if (result == InteractionResult.PASS) {
            BlockEntity blockentity = pState.hasBlockEntity() ? pLevel.getBlockEntity(pPos) : null;
            Block.dropResources((BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos, (BlockEntity)blockentity);
        }
    }

    protected int getSlopeFindDistance(LevelReader pLevel) {
        return this.slopeDistance;
    }

    protected int getDropOff(LevelReader pLevel) {
        return this.dropOff;
    }

    @Nonnull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.ofNullable(this.getFluidType().getSound(SoundActions.BUCKET_FILL));
    }

    public static class Flowing
    extends FlowingFluid {
        private final FlexFlowingFluid parent;

        public Flowing(FlexFlowingFluid parent, Map<Property<?>, Comparable<?>> propertyDefaultValues) {
            this.parent = parent;
            this.initializeFlex(propertyDefaultValues);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public boolean isSame(Fluid pFluid) {
            return pFluid == this.getSource() || pFluid == this.getFlowing();
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
            if (propertyDefaultValues.size() > 0) {
                FluidState def = (FluidState)this.getStateDefinition().any();
                for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                    Property<?> prop = entry.getKey();
                    Comparable<?> value = entry.getValue();
                    def = (FluidState)def.setValue(prop, value);
                }
                this.registerDefaultState(def);
            }
        }

        public FluidType getFluidType() {
            return this.parent.getFluidType();
        }

        public Item getBucket() {
            return this.parent.getBucket();
        }

        protected boolean canBeReplacedWith(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
            return pDirection == Direction.DOWN && !this.isSame(pFluid);
        }

        public int getTickDelay(LevelReader p_76120_) {
            return this.parent.getTickDelay(p_76120_);
        }

        protected float getExplosionResistance() {
            return this.parent.getExplosionResistance();
        }

        protected BlockState createLegacyBlock(FluidState pState) {
            return this.parent.createLegacyBlock(pState);
        }

        public Fluid getFlowing() {
            return this.parent.getFlowing();
        }

        public Fluid getSource() {
            return this.parent.getSource();
        }

        protected boolean canConvertToSource(ServerLevel level) {
            return this.parent.canConvertToSource(level);
        }

        protected void beforeDestroyingBlock(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
            this.parent.beforeDestroyingBlock(pLevel, pPos, pState);
        }

        protected int getSlopeFindDistance(LevelReader pLevel) {
            return this.parent.getSlopeFindDistance(pLevel);
        }

        protected int getDropOff(LevelReader pLevel) {
            return this.parent.getDropOff(pLevel);
        }
    }
}

