/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.items;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import dev.gigaherz.jsonthings.things.events.IEventRunner;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class FlexShovelItem
extends ShovelItem
implements IEventRunner {
    private final Map<FlexEventType, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private ItemAttributeModifiers attributeModifiers;
    private final ItemUseAnimation useAction;
    private final Integer useTime;
    private final UseFinishMode useFinishMode;
    private final List<Component> lore;
    private final Set<ItemAbility> toolActions;

    public FlexShovelItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties, ItemBuilder builder) {
        super(material, attackDamage, attackSpeed, properties);
        this.useAction = builder.getUseAnim();
        this.useTime = builder.getUseTime();
        this.useFinishMode = builder.getUseFinishMode();
        this.attributeModifiers = builder.getAttributeModifiers();
        this.lore = builder.getLore();
        this.toolActions = builder.getToolActions();
        this.initializeFlex();
    }

    private void initializeFlex() {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ItemAttributeModifiers defaults = super.getDefaultAttributeModifiers(new ItemStack((ItemLike)this));
        if (!defaults.modifiers().isEmpty()) {
            for (ItemAttributeModifiers.Entry mod : defaults.modifiers()) {
                builder.add(mod.attribute(), mod.modifier(), mod.slot());
            }
            for (ItemAttributeModifiers.Entry mod : this.attributeModifiers.modifiers()) {
                builder.add(mod.attribute(), mod.modifier(), mod.slot());
            }
            this.attributeModifiers = builder.build();
        }
    }

    @Override
    public <T> void addEventHandler(FlexEventType<T> event, FlexEventHandler<T> eventHandler) {
        this.eventHandlers.put(event, eventHandler);
    }

    @Override
    public <T> FlexEventHandler<T> getEventHandler(FlexEventType<T> event) {
        return this.eventHandlers.get(event);
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.getItemInHand(handIn);
        if (this.useTime != null && this.useTime > 0) {
            return (InteractionResult)this.runEvent(FlexEventType.BEGIN_USING_ITEM, FlexEventContext.of(worldIn, (LivingEntity)playerIn, handIn, heldItem), () -> {
                playerIn.startUsingItem(handIn);
                return InteractionResult.CONSUME;
            });
        }
        return (InteractionResult)this.runEvent(FlexEventType.USE_ITEM_ON_AIR, FlexEventContext.of(worldIn, (LivingEntity)playerIn, handIn, heldItem), () -> super.use(worldIn, playerIn, handIn));
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult.Success success;
        ItemStack heldItem = context.getItemInHand();
        InteractionResult result = (InteractionResult)this.runEvent(FlexEventType.USE_ITEM_ON_BLOCK, FlexEventContext.of(context), () -> super.useOn(context));
        if (result instanceof InteractionResult.Success && (success = (InteractionResult.Success)result).heldItemTransformedTo() != null && success.heldItemTransformedTo() != heldItem && context.getPlayer() != null) {
            context.getPlayer().setItemInHand(context.getHand(), success.heldItemTransformedTo());
        }
        return result;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return Utils.orElseGet(this.useAction, () -> super.getUseAnimation(stack));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return Utils.orElseGet(this.useTime, () -> super.getUseDuration(stack, entity));
    }

    public boolean useOnRelease(ItemStack stack) {
        if (this.useFinishMode != null) {
            return this.useFinishMode.isUseOnRelease();
        }
        return super.useOnRelease(stack);
    }

    public boolean releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        return (Boolean)this.runEvent(FlexEventType.STOPPED_USING, FlexEventContext.of(worldIn, entityLiving, stack).with(FlexEventContext.TIME_LEFT, timeLeft), () -> super.releaseUsing(stack, worldIn, entityLiving, timeLeft));
    }

    public ItemStack finishUsingItem(ItemStack heldItem, Level worldIn, LivingEntity entityLiving) {
        InteractionResult result = (InteractionResult)this.runEvent(FlexEventType.END_USING, FlexEventContext.of(worldIn, entityLiving, heldItem), () -> InteractionResult.SUCCESS.heldItemTransformedTo(super.finishUsingItem(heldItem, worldIn, entityLiving)));
        if (!(result instanceof InteractionResult.Success)) {
            return heldItem;
        }
        InteractionResult result2 = (InteractionResult)this.runEvent(FlexEventType.USE_ITEM_ON_AIR, FlexEventContext.of(worldIn, entityLiving, heldItem), () -> result);
        if (result2 instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)result2;
            return Utils.orElse(success.heldItemTransformedTo(), heldItem);
        }
        return heldItem;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag advanced) {
        super.appendHoverText(stack, context, display, consumer, advanced);
        if (this.lore != null) {
            this.lore.forEach(consumer);
        }
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        FlexEventContext args = FlexEventContext.of((Level)level, entity, stack);
        if (slot != null) {
            args = args.with(FlexEventContext.SLOT, slot);
        }
        SlotAccess slotAccess = null;
        if (slot != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            slotAccess = SlotAccess.forEquipmentSlot((LivingEntity)living, (EquipmentSlot)slot);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            Inventory inv = player.getInventory();
            int slotIdx = -1;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                if (inv.getItem(i) != stack) continue;
                slotIdx = i;
                break;
            }
            if (slotIdx >= 0) {
                slotAccess = SlotAccess.forContainer((Container)inv, (int)slotIdx);
            }
        }
        ItemStack result = (ItemStack)this.runEvent(FlexEventType.UPDATE, args, () -> {
            super.inventoryTick(stack, level, entity, slot);
            return stack;
        });
        if (result != stack && slotAccess != null) {
            slotAccess.set(result);
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.attributeModifiers;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (this.toolActions != null) {
            return this.toolActions.contains(toolAction);
        }
        return super.canPerformAction(stack, toolAction);
    }
}

