/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.ArmorMaterialBuilder;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.bus.api.IEventBus;

public class ArmorMaterialParser
extends ThingParser<ArmorMaterial, ArmorMaterialBuilder> {
    public ArmorMaterialParser(IEventBus bus) {
        super(GSON, "armor_material");
    }

    @Override
    protected void finishLoadingInternal() {
        ArmorMaterialParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.register(ThingRegistries.ARMOR_MATERIAL, (ResourceLocation)thing.getRegistryName(), (Object)((ArmorMaterial)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public ArmorMaterialBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ArmorMaterialBuilder> builderModification) {
        ArmorMaterialBuilder builder = ArmorMaterialBuilder.begin(this, key);
        JParse.begin(data).key("toughness", val -> val.floatValue().min(0.0f).handle(builder::setToughness)).key("knockback_resistance", val -> val.floatValue().min(0.0f).handle(builder::setKnockbackResistance)).key("enchantment_value", val -> val.intValue().min(0).handle(builder::setEnchantmentValue)).key("repair_ingredient", val -> val.string().map(Utils::itemTag).handle(builder::setRepairIngredient)).key("equip_sound", val -> val.string().map(ResourceLocation::parse).handle(builder::setEquipSound)).key("durability", val -> val.intValue().handle(builder::setDurability)).key("armor", val -> val.map(this::parseArmorType).handle(builder::setDefense));
        builderModification.accept(builder);
        return builder;
    }

    private Map<ArmorType, Integer> parseArmorType(Any data) {
        HashMap<ArmorType, Integer> map = new HashMap<ArmorType, Integer>();
        data.ifObj(obj -> {
            for (ArmorType slot : ArmorType.values()) {
                obj.ifKey(slot.getName(), val -> val.intValue().min(0).handle(num -> map.put(slot, num)));
            }
        }).ifInteger(val -> val.min(0).handle(num -> {
            for (ArmorType slot : ArmorType.values()) {
                map.put(slot, num);
            }
        })).typeError();
        return map;
    }
}

