/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.builders.FluidTypeBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidTypeParser
extends ThingParser<FluidType, FluidTypeBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public FluidTypeParser(IEventBus bus) {
        super(GSON, "fluid_type");
        this.register(bus, NeoForgeRegistries.Keys.FLUID_TYPES);
    }

    @Override
    public FluidTypeBuilder processThing(ResourceLocation key, JsonObject data, Consumer<FluidTypeBuilder> builderModification) {
        FluidTypeBuilder builder = FluidTypeBuilder.begin(this, key);
        JParse.begin(data).ifKey("parent", val -> val.string().map(ResourceLocation::parse).handle(builder::setParent)).ifKey("translation_key", val -> val.string().handle(builder::setTranslationKey)).ifKey("still_texture", val -> val.string().map(ResourceLocation::parse).handle(builder::setStillTexture)).ifKey("flowing_texture", val -> val.string().map(ResourceLocation::parse).handle(builder::setFlowingTexture)).ifKey("side_texture", val -> val.string().map(ResourceLocation::parse).handle(builder::setSideTexture)).ifKey("rarity", val -> val.string().map(ThingParser::parseRarity).handle(builder::setRarity)).ifKey("color", val -> val.ifObj(obj -> obj.map(ThingParser::parseColor).handle(builder::setColor)).ifArray(arr -> arr.mapWhole(ThingParser::parseColor).handle(builder::setColor)).ifString(str -> str.map(ThingParser::parseColor).handle(builder::setColor)).ifInteger(i -> i.handle(builder::setColor)).typeError()).ifKey("density", val -> val.intValue().handle(builder::setDensity)).ifKey("luminosity", val -> val.intValue().handle(builder::setLightLevel)).ifKey("temperature", val -> val.intValue().handle(builder::setTemperature)).ifKey("viscosity", val -> val.intValue().handle(builder::setViscosity)).ifKey("gaseous", val -> val.bool().handle(builder::setGaseous)).ifKey("motion_scale", val -> val.doubleValue().handle(builder::setMotionScale)).ifKey("fall_distance_modifier", val -> val.floatValue().handle(builder::setFallDistanceModifier)).ifKey("can_push_entity", val -> val.bool().handle(builder::setCanPushEntity)).ifKey("can_swim", val -> val.bool().handle(builder::setCanSwim)).ifKey("can_drown", val -> val.bool().handle(builder::setCanDrown)).ifKey("can_extinguish", val -> val.bool().handle(builder::setCanExtinguish)).ifKey("can_hydrate", val -> val.bool().handle(builder::setCanHydrate)).ifKey("can_convert_to_source", val -> val.bool().handle(builder::setCanConvertToSource)).ifKey("supports_boating", val -> val.bool().handle(builder::setSupportsBoating)).ifKey("sounds", val -> val.obj().ifKey("bucket_fill", val1 -> val1.string().map(ResourceLocation::parse).handle(builder::setFillSound)).ifKey("bucket_empty", val1 -> val1.string().map(ResourceLocation::parse).handle(builder::setEmptySound)).ifKey("fluid_vaporize", val1 -> val1.string().map(ResourceLocation::parse).handle(builder::setVaporizeSound))).ifKey("events", val -> val.obj().map(this::parseEvents).handle(builder::setEventMap));
        builderModification.accept(builder);
        return builder;
    }
}

