/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodPropertiesBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;

public class FoodPropertiesParser
extends ThingParser<FoodProperties, FoodPropertiesBuilder> {
    public FoodPropertiesParser() {
        super(GSON, "food");
    }

    @Override
    protected void finishLoadingInternal() {
        FoodPropertiesParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.register(ThingRegistries.FOOD, (ResourceLocation)thing.getRegistryName(), (Object)((FoodProperties)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public FoodPropertiesBuilder processThing(ResourceLocation key, JsonObject data, Consumer<FoodPropertiesBuilder> builderModification) {
        FoodPropertiesBuilder builder = FoodPropertiesBuilder.begin(this, key);
        JParse.begin(data).key("nutrition", val -> val.intValue().min(1).handle(builder::setNutrition)).key("saturation", val -> val.floatValue().min(0.0f).handle(builder::setSaturation)).ifKey("always_eat", val -> val.bool().handle(builder::setAlwaysEat));
        builderModification.accept(builder);
        return builder;
    }
}

