/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.common.primitives.Ints;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodPropertiesBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.items.FlexBucketItem;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.StringValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemParser
extends ThingParser<Item, ItemBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceKey<CreativeModeTab>, List<ItemStack>> creativeStacks = new HashMap<ResourceKey<CreativeModeTab>, List<ItemStack>>();
    private static final Codec<List<Component>> LORE_CODEC = ComponentSerialization.CODEC.listOf();

    public ItemParser(IEventBus bus) {
        super(GSON, "item");
        this.register(bus, Registries.ITEM);
        bus.addListener(this::registerCapabilities);
        bus.addListener(this::addToTabs);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ItemParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> {
            Item item = (Item)thing.get();
            if (item instanceof FlexBucketItem) {
                event.registerItem(Capabilities.Fluid.ITEM, (stack, access) -> access != null ? new BucketResourceHandler(access) : null, new ItemLike[]{item});
            }
        }, BaseBuilder::getRegistryName);
    }

    public void addToTabs(BuildCreativeModeTabContentsEvent event) {
        ItemParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> thing.provideVariants((ResourceKey<CreativeModeTab>)event.getTabKey(), (CreativeModeTab.Output)event, event.getParameters(), (ItemBuilder)thing, false), BaseBuilder::getRegistryName);
    }

    @Override
    public ItemBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ItemBuilder> builderModification) {
        ItemBuilder builder = ItemBuilder.begin(this, key);
        JParse.begin(data).ifKey("parent", val -> val.string().map(ResourceLocation::parse).handle(builder::setParent)).ifKey("type", val -> val.string().handle(builder::setType)).ifKey("max_stack_size", val -> val.intValue().range(1, 128).handle(builder::setMaxStackSize)).mutex(List.of("group", "creative_menu_stacks"), () -> new ThingParseException("Cannot have group and creative_menu_stacks at the same time.")).ifKey("group", val -> val.string().map(ResourceLocation::parse).handle(builder::setGroup)).ifKey("creative_menu_stacks", val -> val.array().forEach((i, entry) -> entry.obj().raw(item -> builder.withCreativeMenuStack(this.parseStackContext((JsonObject)item, false, false), ItemParser.parseTabsList(item))))).ifKey("attribute_modifiers", val -> val.array().raw(arr -> this.parseAttributeModifiers((JsonArray)arr, builder))).ifKey("max_damage", val -> val.intValue().min(1).handle(builder::setMaxDamage)).ifKey("fire_resistant", val -> val.bool().handle(builder::setFireResistant)).ifKey("food", val -> val.ifString(str -> str.map(ResourceLocation::parse).handle(builder::setFood)).ifObj(obj -> obj.raw(food -> {
            try {
                FoodPropertiesBuilder foodPropertiesBuilder = (FoodPropertiesBuilder)JsonThings.foodPropertiesParser.parseFromElement(builder.getRegistryName(), (JsonElement)food);
                if (foodPropertiesBuilder != null) {
                    builder.setFood((FoodProperties)foodPropertiesBuilder.get());
                }
            }
            catch (Exception e) {
                throw new ThingParseException("Exception while parsing nested food in " + String.valueOf(builder.getRegistryName()) + ": " + e.getMessage(), e);
            }
        })).typeError()).ifKey("container", val -> val.string().map(ResourceLocation::parse).handle(builder::setContainerItem)).ifKey("delayed_use", val -> val.obj().key("duration", val1 -> val1.intValue().handle(builder::setUseTime)).key("animation", val1 -> val1.string().map(str -> ItemUseAnimation.valueOf((String)str.toUpperCase())).handle(builder::setUseAnim)).ifKey("on_complete", val1 -> val1.string().map(str -> UseFinishMode.valueOf(str.toUpperCase())).handle(builder::setUseFinishMode))).ifKey("color_handler", val -> val.string().handle(builder::setColorHandler)).ifKey("lore", val -> val.array().unwrapRaw(this::parseLore).handle(builder::setLore)).ifKey("tool_actions", val -> val.array().strings().flatten(StringValue::getAsString, String[]::new).handle(builder::setToolActions)).ifKey("events", val -> val.obj().map(this::parseEvents).handle(builder::setEventMap)).ifKey("components", val -> val.obj().raw(builder::setComponents));
        builderModification.accept(builder);
        builder.setFactory(builder.getType().getFactory(data));
        return builder;
    }

    private List<Component> parseLore(JsonArray lines) {
        return (List)((Pair)LORE_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)lines).getOrThrow(ThingParseException::new)).getFirst();
    }

    private void parseAttributeModifiers(JsonArray list, ItemBuilder builder) {
        for (JsonElement e : list) {
            String uuidString;
            String loc;
            JsonObject item = e.getAsJsonObject();
            if (!item.has("slot")) {
                throw new ThingParseException("Attribute modifier slot must be a non-empty string.");
            }
            String name = item.get("slot").getAsString();
            EquipmentSlotGroup slot = EquipmentSlotGroup.bySlot((EquipmentSlot)EquipmentSlot.byName((String)name));
            if (item.has("attribute")) {
                loc = item.get("attribute").getAsString();
                if (Strings.isNullOrEmpty((String)loc)) {
                    throw new ThingParseException("Attribute must be present and a valid resource location.");
                }
            } else {
                throw new ThingParseException("Attribute must be present and a valid resource location.");
            }
            ResourceLocation attribute = ResourceLocation.parse((String)loc);
            if (item.has("id")) {
                uuidString = item.get("id").getAsString();
                if (Strings.isNullOrEmpty((String)uuidString)) {
                    throw new ThingParseException("Attribute modifier id must be present and a valid resource location.");
                }
            } else {
                throw new ThingParseException("Attribute modifier id must be present and a valid resource location.");
            }
            ResourceLocation id = ResourceLocation.parse((String)uuidString);
            if (!item.has("amount")) {
                throw new ThingParseException("Attribute modifier amount must be a floating point number.");
            }
            double amount = item.get("amount").getAsDouble();
            if (!item.has("operation")) {
                throw new ThingParseException("Attribute modifier amount must have an operation type.");
            }
            String opName = item.get("operation").getAsString();
            Integer opInt = Ints.tryParse((String)opName);
            AttributeModifier.Operation operation = opInt != null ? (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(opInt) : AttributeModifier.Operation.valueOf((String)opName.toUpperCase());
            builder.withAttributeModifier(slot, attribute, id, amount, operation);
        }
    }

    public static ResourceLocation[] parseTabsList(JsonObject stackEntry) {
        if (stackEntry.has("tabs")) {
            JsonArray tabs = stackEntry.get("tabs").getAsJsonArray();
            ResourceLocation[] tabsArray = new ResourceLocation[tabs.size()];
            int tabIndex = 0;
            for (JsonElement e : tabs) {
                String str = e.getAsString();
                if (!Strings.isNullOrEmpty((String)str)) {
                    tabsArray[tabIndex++] = ResourceLocation.parse((String)str);
                    continue;
                }
                throw new ThingParseException("Tabs array must contain non-empty strings.");
            }
            return tabsArray;
        }
        throw new ThingParseException("Creative menu entry must contain a list of tabs.");
    }
}

