/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ShapeBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class ShapeParser
extends ThingParser<DynamicShape, ShapeBuilder> {
    public ShapeParser() {
        super(GSON, "shape");
    }

    @Override
    protected void finishLoadingInternal() {
        ShapeParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.register(ThingRegistries.DYNAMIC_SHAPE, (ResourceLocation)thing.getRegistryName(), (Object)((DynamicShape)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    protected ShapeBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ShapeBuilder> builderModification) {
        ShapeBuilder builder = ShapeBuilder.begin(this, key, DynamicShape.fromJson((JsonElement)data, null, name -> (Property)ThingRegistries.PROPERTY.getOptional(ResourceLocation.parse((String)name)).orElseThrow()));
        builderModification.accept(builder);
        return builder;
    }
}

