/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ToolMaterialBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ToolMaterial;

public class ToolMaterialParser
extends ThingParser<ToolMaterial, ToolMaterialBuilder> {
    public ToolMaterialParser() {
        super(GSON, "item_tier");
    }

    @Override
    protected void finishLoadingInternal() {
        ToolMaterialParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.register(ThingRegistries.TOOL_MATERIAL, (ResourceLocation)thing.getRegistryName(), (Object)((ToolMaterial)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public ToolMaterialBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ToolMaterialBuilder> builderModification) {
        ToolMaterialBuilder builder = ToolMaterialBuilder.begin(this, key);
        JParse.begin(data).key("uses", val -> val.intValue().min(1).handle(builder::setUses)).key("speed", val -> val.floatValue().min(1.0f).handle(builder::setSpeed)).key("attack_damage_bonus", val -> val.floatValue().min(1.0f).handle(builder::setAttackDamageBonus)).key("enchantment_value", val -> val.intValue().min(1).handle(builder::setEnchantmentValue)).key("tag", val -> val.string().map(Utils::blockTag).handle(builder::setTag)).key("repair_ingredient", val -> val.string().map(Utils::itemTag).handle(builder::setRepairIngredient));
        builderModification.accept(builder);
        return builder;
    }
}

