/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.properties;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Function3;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.properties.CustomProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class PropertyType {
    public static Property<?> deserialize(String name, JsonObject data) {
        String key = GsonHelper.getAsString((JsonObject)data, (String)"type");
        PropertyType prop = (PropertyType)ThingRegistries.PROPERTY_TYPE.getOptional(ResourceLocation.parse((String)key)).orElseThrow(() -> new IllegalStateException("Property type not found " + key));
        return prop.read(name, data);
    }

    public static JsonObject serialize(Property<?> property) {
        for (Map.Entry entry : ThingRegistries.PROPERTY_TYPE.entrySet()) {
            String key = ((ResourceKey)entry.getKey()).location().toString();
            PropertyType prop = (PropertyType)entry.getValue();
            if (!prop.handles(property)) continue;
            JsonObject data = new JsonObject();
            prop.write(data, property);
            data.addProperty("type", key);
            return data;
        }
        throw new IllegalStateException("No serializer can handle the given property " + String.valueOf(property));
    }

    public abstract boolean handles(Property<?> var1);

    public abstract Property<?> read(String var1, JsonObject var2);

    public abstract void write(JsonObject var1, Property<?> var2);

    public String toString() {
        return "PropertyType{" + String.valueOf(ThingRegistries.PROPERTY_TYPE.getKey((Object)this)) + "}";
    }

    public static class EnumType
    extends PropertyType {
        @Override
        public boolean handles(Property<?> property) {
            return property instanceof EnumProperty;
        }

        @Override
        public Property<?> read(String name, JsonObject data) {
            Class<?> cls;
            String className = GsonHelper.getAsString((JsonObject)data, (String)"class");
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Error getting class " + className, e);
            }
            if (!cls.isEnum()) {
                throw new IllegalStateException("Not an enum type " + className);
            }
            if (!StringRepresentable.class.isAssignableFrom(cls)) {
                throw new IllegalStateException("Enum type " + className + " not IStringSerializable");
            }
            ArrayList valid_values = Lists.newArrayList();
            if (data.has("values")) {
                ?[] enum_values = cls.getEnumConstants();
                StringRepresentable[] serializables = (StringRepresentable[])Arrays.stream(enum_values).map(s -> (StringRepresentable)s).toArray(StringRepresentable[]::new);
                JsonArray values = data.get("values").getAsJsonArray();
                for (JsonElement e : values) {
                    String val = e.getAsJsonPrimitive().getAsString();
                    for (StringRepresentable s2 : serializables) {
                        if (!s2.getSerializedName().equals(val)) continue;
                        valid_values.add(s2);
                    }
                }
            }
            return EnumProperty.create((String)name, cls, (List)valid_values);
        }

        @Override
        public void write(JsonObject data, Property<?> property) {
            List valid_values = property.getPossibleValues();
            Class<?> cls = valid_values.stream().findFirst().get().getClass();
            ?[] enum_values = cls.getEnumConstants();
            if (enum_values.length > valid_values.size()) {
                JsonArray list = new JsonArray();
                valid_values.stream().map(s -> ((StringRepresentable)s).getSerializedName()).forEach(arg_0 -> ((JsonArray)list).add(arg_0));
                data.add("values", (JsonElement)list);
            }
            data.addProperty("class", cls.getName());
        }
    }

    public static class DirectionType
    extends PropertyType {
        @Override
        public boolean handles(Property<?> property) {
            return property instanceof BooleanProperty;
        }

        @Override
        public Property<?> read(String name, JsonObject data) {
            ArrayList valid_values = Lists.newArrayList();
            if (data.has("values")) {
                JsonArray values = data.get("values").getAsJsonArray();
                for (JsonElement e : values) {
                    String val = e.getAsJsonPrimitive().getAsString();
                    valid_values.add(Direction.byName((String)val));
                }
                return EnumProperty.create((String)name, Direction.class, (List)valid_values);
            }
            return EnumProperty.create((String)name, Direction.class);
        }

        @Override
        public void write(JsonObject data, Property<?> property) {
            List valid_values = ((EnumProperty)property).getPossibleValues();
            Direction[] values = Direction.values();
            if (values.length > valid_values.size()) {
                JsonArray list = new JsonArray();
                valid_values.stream().map(Direction::getSerializedName).forEach(arg_0 -> ((JsonArray)list).add(arg_0));
                data.add("values", (JsonElement)list);
            }
        }
    }

    public static class StringType
    extends PropertyType {
        @Override
        public boolean handles(Property<?> property) {
            return property instanceof CustomProperty;
        }

        @Override
        public Property<?> read(String name, JsonObject data) {
            ArrayList valid_values = Lists.newArrayList();
            if (data.has("values")) {
                JsonArray values = data.get("values").getAsJsonArray();
                for (JsonElement e : values) {
                    String val = e.getAsJsonPrimitive().getAsString();
                    valid_values.add(val);
                }
                return CustomProperty.create(name, valid_values);
            }
            return CustomProperty.create(name, new String[0]);
        }

        @Override
        public void write(JsonObject data, Property<?> property) {
            List<String> valid_values = ((CustomProperty)property).getPossibleValues();
            JsonArray list = new JsonArray();
            valid_values.forEach(arg_0 -> ((JsonArray)list).add(arg_0));
            data.add("values", (JsonElement)list);
        }
    }

    public static class RangeType<T extends Comparable<T>, P extends Property<T>>
    extends PropertyType {
        private final Class<P> cls;
        private final Function3<String, T, T, P> factory;
        private final Function<JsonElement, T> parseBound;

        public RangeType(Class<P> cls, Function3<String, T, T, P> factory, Function<JsonElement, T> parseBound) {
            this.cls = cls;
            this.factory = factory;
            this.parseBound = parseBound;
        }

        @Override
        public boolean handles(Property<?> property) {
            return this.cls.isInstance(property);
        }

        @Override
        public Property<?> read(String name, JsonObject data) {
            if (!data.has("min")) {
                throw new IllegalStateException("Requires a value 'min' of the right type.");
            }
            if (!data.has("max")) {
                throw new IllegalStateException("Requires a value 'max' of the right type.");
            }
            Comparable min = (Comparable)this.parseBound.apply(data.get("min"));
            Comparable max = (Comparable)this.parseBound.apply(data.get("max"));
            return (Property)this.factory.apply((Object)name, (Object)min, (Object)max);
        }

        @Override
        public void write(JsonObject data, Property<?> property) {
            property.getPossibleValues().stream().min(Comparable::compareTo).ifPresent(v -> data.addProperty("min", v.toString()));
            property.getPossibleValues().stream().max(Comparable::compareTo).ifPresent(v -> data.addProperty("max", v.toString()));
        }
    }

    public static class BoolType
    extends PropertyType {
        @Override
        public boolean handles(Property<?> property) {
            return property instanceof BooleanProperty;
        }

        @Override
        public Property<?> read(String name, JsonObject data) {
            return BooleanProperty.create((String)name);
        }

        @Override
        public void write(JsonObject data, Property<?> property) {
        }
    }
}

