/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino;

import com.google.common.collect.Sets;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import dev.gigaherz.jsonthings.things.scripting.ThingScript;
import dev.gigaherz.jsonthings.things.scripting.rhino.FlexEventScriptable;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.AttributesDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.BlocksDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.ChatDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.EffectsDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.EntitiesDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.ItemsDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.LambdaBaseFunction;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.LevelsDSL;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.NbtDSL;
import dev.gigaherz.rhinolib.BaseFunction;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.EcmaError;
import dev.gigaherz.rhinolib.Function;
import dev.gigaherz.rhinolib.NativeJavaClass;
import dev.gigaherz.rhinolib.NativeJavaMethod;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.Script;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Undefined;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.annotation.WillClose;
import javax.script.ScriptException;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RhinoThingScript
extends ThingScript {
    public static final Logger LOGGER = LogManager.getLogger();
    private final Scriptable scope;
    private final Function function;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RhinoThingScript fromResource(@WillClose Resource resource, String name) throws IOException, ScriptException {
        Context cx = Context.enter();
        try (BufferedReader reader = resource.openAsReader();){
            ScriptableObject scope = cx.initStandardObjects();
            Script script = cx.compileReader((Reader)reader, name, 0, null);
            Logger logger = LogManager.getLogger((String)("ThingScript/" + name));
            scope = RhinoThingScript.initDSL(cx, (Scriptable)scope, logger);
            script.exec(cx, (Scriptable)scope);
            Object result = scope.get(cx, "apply", (Scriptable)scope);
            if (!(result instanceof Function)) throw new ScriptException("Error evaluating script " + name + ": Function 'apply' not found or not a function.");
            Function function = (Function)result;
            RhinoThingScript rhinoThingScript = new RhinoThingScript((Scriptable)scope, function);
            return rhinoThingScript;
        }
        catch (EcmaError e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public RhinoThingScript(Scriptable scope, Function function) {
        this.scope = scope;
        this.function = function;
    }

    @Override
    public Object apply(FlexEventType event, FlexEventContext context) {
        Context cx = Context.enter();
        FlexEventScriptable wrappedContext = new FlexEventScriptable(this.scope, context, cx);
        Object result = this.function.call(cx, this.scope, this.scope, new Object[]{event, wrappedContext});
        return ((NativeJavaObject)result).unwrap();
    }

    private static Scriptable initDSL(Context cx, Scriptable _scope, Logger logger) {
        final Scriptable scope = _scope;
        scope.put(cx, "Log", scope, (Object)new NativeJavaObject(scope, (Object)logger, Logger.class, cx));
        scope.put(cx, "Java", scope, (Object)new NativeJavaObject(scope, (Object)new JavaTypeAdapter(scope), JavaTypeAdapter.class, cx));
        scope.put(cx, "useClass", scope, (Object)new BaseFunction(){
            final JavaTypeAdapter adapter;
            {
                this.adapter = new JavaTypeAdapter(scope);
            }

            public Object call(Context cx, Scriptable _scope, Scriptable thisObj, Object[] args) {
                for (Object arg : args) {
                    this.adapter.doImport(cx, (String)arg);
                }
                return Undefined.instance;
            }
        });
        scope.put(cx, "use", scope, (Object)new LambdaBaseFunction((cx1, __scope, thisObj, args) -> {
            block20: for (Object arg : args) {
                switch ((String)arg) {
                    case "nbt": {
                        NbtDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "chat": {
                        ChatDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "items": {
                        ItemsDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "blocks": {
                        BlocksDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "levels": {
                        LevelsDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "entities": {
                        EntitiesDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "effects": {
                        EffectsDSL.use(cx1, scope);
                        continue block20;
                    }
                    case "attributes": {
                        AttributesDSL.use(cx1, scope);
                    }
                }
            }
            return Undefined.instance;
        }));
        return scope;
    }

    public static class JavaTypeAdapter {
        public static Set<String> BLOCKED_PACKAGE_PREFIXES = Sets.newHashSet((Object[])new String[]{"java.", "javax.", "sun."});
        public static Set<String> BLOCKED_PACKAGE_PREFIXE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"java.lang.", "java.math.", "java.util."});
        private final Scriptable scope;

        public JavaTypeAdapter(Scriptable scope) {
            this.scope = scope;
        }

        public Object type(Context cx, String typename) throws ClassNotFoundException {
            if (!BLOCKED_PACKAGE_PREFIXES.contains(typename) || BLOCKED_PACKAGE_PREFIXE_EXCEPTIONS.contains(typename)) {
                Class<?> cls = Class.forName(typename);
                return new NativeJavaClass(cx, this.scope, cls, false);
            }
            throw new ClassNotFoundException(typename);
        }

        public void doImport(Context cx, String importString) {
            try {
                if (importString.endsWith(".*")) {
                    importString = importString.substring(0, importString.length() - 2);
                    Class<?> cls = Class.forName(importString);
                    for (Method method : cls.getMethods()) {
                        int flags = method.getModifiers();
                        if (!Modifier.isPublic(flags) || !Modifier.isStatic(flags)) continue;
                        this.scope.put(cx, method.getName(), this.scope, (Object)new NativeJavaMethod(method, method.getName()));
                    }
                } else {
                    int last = importString.lastIndexOf(".");
                    String className = last >= 0 ? importString.substring(last + 1) : importString;
                    Class<?> cls = Class.forName(importString);
                    this.scope.put(cx, className, this.scope, (Object)new NativeJavaClass(cx, this.scope, cls, false));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface LambdaFunction {
        public Object call(Context var1, Scriptable var2, Scriptable var3, Object[] var4);
    }
}

