/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things;

import com.mojang.serialization.Lifecycle;
import dev.gigaherz.jsonthings.things.properties.PropertyType;
import dev.gigaherz.jsonthings.things.properties.PropertyTypes;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.FlexFluidType;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.MapColors;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ThingRegistries {
    public static final ResourceKey<Registry<Registry<?>>> THING_REGISTRIES_REGISTRY = ThingRegistries.createKey("jsonthings:registries");
    public static final ResourceKey<Registry<ToolMaterial>> TOOL_MATERIAL_REGISTRY = ThingRegistries.createKey("jsonthings:tool_material");
    public static final ResourceKey<Registry<ArmorMaterial>> ARMOR_MATERIAL_REGISTRY = ThingRegistries.createKey("jsonthings:armor_material");
    public static final ResourceKey<Registry<FoodProperties>> FOOD_REGISTRY = ThingRegistries.createKey("jsonthings:food");
    public static final ResourceKey<Registry<PropertyType>> PROPERTY_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:property_type");
    public static final ResourceKey<Registry<Property<?>>> PROPERTY_REGISTRY = ThingRegistries.createKey("jsonthings:property");
    public static final ResourceKey<Registry<DynamicShape>> DYNAMIC_SHAPE_REGISTRY = ThingRegistries.createKey("jsonthings:dynamic_shapes");
    public static final ResourceKey<Registry<FlexBlockType<?>>> BLOCK_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:block_types");
    public static final ResourceKey<Registry<FlexItemType<?>>> ITEM_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:item_types");
    public static final ResourceKey<Registry<SoundType>> SOUND_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:sound_types");
    public static final ResourceKey<Registry<FlexFluidType<?>>> FLUID_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:fluid_types");
    public static final Registry<Registry<?>> THING_REGISTRIES = new MappedRegistry(THING_REGISTRIES_REGISTRY, Lifecycle.experimental(), false);
    public static final Registry<ToolMaterial> TOOL_MATERIAL = ThingRegistries.makeRegistry(TOOL_MATERIAL_REGISTRY);
    public static final Registry<ArmorMaterial> ARMOR_MATERIAL = ThingRegistries.makeRegistry(ARMOR_MATERIAL_REGISTRY);
    public static final Registry<FoodProperties> FOOD = ThingRegistries.makeRegistry(FOOD_REGISTRY);
    public static final Registry<PropertyType> PROPERTY_TYPE = ThingRegistries.makeRegistry(PROPERTY_TYPE_REGISTRY);
    public static final Registry<Property<?>> PROPERTY = ThingRegistries.makeRegistry(PROPERTY_REGISTRY);
    public static final Registry<DynamicShape> DYNAMIC_SHAPE = ThingRegistries.makeRegistry(DYNAMIC_SHAPE_REGISTRY);
    public static final Registry<FlexItemType<?>> ITEM_TYPE = ThingRegistries.makeRegistry(ITEM_TYPE_REGISTRY);
    public static final Registry<FlexBlockType<?>> BLOCK_TYPE = ThingRegistries.makeRegistry(BLOCK_TYPE_REGISTRY);
    public static final Registry<SoundType> SOUND_TYPE = ThingRegistries.makeRegistry(SOUND_TYPE_REGISTRY);
    public static final Registry<FlexFluidType<?>> FLUID_TYPE = ThingRegistries.makeRegistry(FLUID_TYPE_REGISTRY);

    public static void staticInit() {
    }

    private static <T> ResourceKey<Registry<T>> createKey(String name) {
        return ResourceKey.createRegistryKey((Identifier)Identifier.parse((String)name));
    }

    private static <T> Registry<T> makeRegistry(ResourceKey<Registry<T>> key) {
        MappedRegistry registry = new MappedRegistry(key, Lifecycle.experimental(), false);
        return (Registry)Registry.register(THING_REGISTRIES, (String)key.identifier().toString(), (Object)registry);
    }

    private static void registerToolMaterials() {
        for (Field field : ToolMaterial.class.getDeclaredFields()) {
            if (!field.accessFlags().contains((Object)AccessFlag.STATIC) || !field.accessFlags().contains((Object)AccessFlag.PUBLIC) || field.getType() != ToolMaterial.class) continue;
            try {
                Registry.register(TOOL_MATERIAL, (String)field.getName().toLowerCase(), (Object)((ToolMaterial)field.get(null)));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void registerArmorMaterials() {
        for (Field field : ArmorMaterials.class.getDeclaredFields()) {
            if (!field.accessFlags().contains((Object)AccessFlag.STATIC) || !field.accessFlags().contains((Object)AccessFlag.PUBLIC) || field.getType() != ArmorMaterial.class) continue;
            try {
                Registry.register(ARMOR_MATERIAL, (String)field.getName().toLowerCase(), (Object)((ArmorMaterial)field.get(null)));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void registerDynamicShapes() {
        Registry.register(DYNAMIC_SHAPE, (String)"empty", (Object)DynamicShape.empty());
    }

    private static void registerProperties() {
        Registry.register(PROPERTY, (String)"attached", (Object)BlockStateProperties.ATTACHED);
        Registry.register(PROPERTY, (String)"berries", (Object)BlockStateProperties.BERRIES);
        Registry.register(PROPERTY, (String)"bloom", (Object)BlockStateProperties.BLOOM);
        Registry.register(PROPERTY, (String)"bottom", (Object)BlockStateProperties.BOTTOM);
        Registry.register(PROPERTY, (String)"can_summon", (Object)BlockStateProperties.CAN_SUMMON);
        Registry.register(PROPERTY, (String)"conditional", (Object)BlockStateProperties.CONDITIONAL);
        Registry.register(PROPERTY, (String)"disarmed", (Object)BlockStateProperties.DISARMED);
        Registry.register(PROPERTY, (String)"drag", (Object)BlockStateProperties.DRAG);
        Registry.register(PROPERTY, (String)"enabled", (Object)BlockStateProperties.ENABLED);
        Registry.register(PROPERTY, (String)"extended", (Object)BlockStateProperties.EXTENDED);
        Registry.register(PROPERTY, (String)"eye", (Object)BlockStateProperties.EYE);
        Registry.register(PROPERTY, (String)"falling", (Object)BlockStateProperties.FALLING);
        Registry.register(PROPERTY, (String)"hanging", (Object)BlockStateProperties.HANGING);
        Registry.register(PROPERTY, (String)"has_bottle_0", (Object)BlockStateProperties.HAS_BOTTLE_0);
        Registry.register(PROPERTY, (String)"has_bottle_1", (Object)BlockStateProperties.HAS_BOTTLE_1);
        Registry.register(PROPERTY, (String)"has_bottle_2", (Object)BlockStateProperties.HAS_BOTTLE_2);
        Registry.register(PROPERTY, (String)"has_record", (Object)BlockStateProperties.HAS_RECORD);
        Registry.register(PROPERTY, (String)"has_book", (Object)BlockStateProperties.HAS_BOOK);
        Registry.register(PROPERTY, (String)"inverted", (Object)BlockStateProperties.INVERTED);
        Registry.register(PROPERTY, (String)"in_wall", (Object)BlockStateProperties.IN_WALL);
        Registry.register(PROPERTY, (String)"lit", (Object)BlockStateProperties.LIT);
        Registry.register(PROPERTY, (String)"locked", (Object)BlockStateProperties.LOCKED);
        Registry.register(PROPERTY, (String)"natural", (Object)BlockStateProperties.NATURAL);
        Registry.register(PROPERTY, (String)"occupied", (Object)BlockStateProperties.OCCUPIED);
        Registry.register(PROPERTY, (String)"open", (Object)BlockStateProperties.OPEN);
        Registry.register(PROPERTY, (String)"persistent", (Object)BlockStateProperties.PERSISTENT);
        Registry.register(PROPERTY, (String)"powered", (Object)BlockStateProperties.POWERED);
        Registry.register(PROPERTY, (String)"short", (Object)BlockStateProperties.SHORT);
        Registry.register(PROPERTY, (String)"shrieking", (Object)BlockStateProperties.SHRIEKING);
        Registry.register(PROPERTY, (String)"signal_fire", (Object)BlockStateProperties.SIGNAL_FIRE);
        Registry.register(PROPERTY, (String)"snowy", (Object)BlockStateProperties.SNOWY);
        Registry.register(PROPERTY, (String)"tip", (Object)BlockStateProperties.TIP);
        Registry.register(PROPERTY, (String)"triggered", (Object)BlockStateProperties.TRIGGERED);
        Registry.register(PROPERTY, (String)"unstable", (Object)BlockStateProperties.UNSTABLE);
        Registry.register(PROPERTY, (String)"waterlogged", (Object)BlockStateProperties.WATERLOGGED);
        Registry.register(PROPERTY, (String)"horizontal_axis", (Object)BlockStateProperties.HORIZONTAL_AXIS);
        Registry.register(PROPERTY, (String)"axis", (Object)BlockStateProperties.AXIS);
        Registry.register(PROPERTY, (String)"up", (Object)BlockStateProperties.UP);
        Registry.register(PROPERTY, (String)"down", (Object)BlockStateProperties.DOWN);
        Registry.register(PROPERTY, (String)"north", (Object)BlockStateProperties.NORTH);
        Registry.register(PROPERTY, (String)"east", (Object)BlockStateProperties.EAST);
        Registry.register(PROPERTY, (String)"south", (Object)BlockStateProperties.SOUTH);
        Registry.register(PROPERTY, (String)"west", (Object)BlockStateProperties.WEST);
        Registry.register(PROPERTY, (String)"facing", (Object)BlockStateProperties.FACING);
        Registry.register(PROPERTY, (String)"facing_except_up", (Object)BlockStateProperties.FACING_HOPPER);
        Registry.register(PROPERTY, (String)"horizontal_facing", (Object)BlockStateProperties.HORIZONTAL_FACING);
        Registry.register(PROPERTY, (String)"flower_amount", (Object)BlockStateProperties.FLOWER_AMOUNT);
        Registry.register(PROPERTY, (String)"segment_amount", (Object)BlockStateProperties.SEGMENT_AMOUNT);
        Registry.register(PROPERTY, (String)"orientation", (Object)BlockStateProperties.ORIENTATION);
        Registry.register(PROPERTY, (String)"face", (Object)BlockStateProperties.ATTACH_FACE);
        Registry.register(PROPERTY, (String)"bell_attachment", (Object)BlockStateProperties.BELL_ATTACHMENT);
        Registry.register(PROPERTY, (String)"wall_height_east", (Object)BlockStateProperties.EAST_WALL);
        Registry.register(PROPERTY, (String)"wall_height_north", (Object)BlockStateProperties.NORTH_WALL);
        Registry.register(PROPERTY, (String)"wall_height_south", (Object)BlockStateProperties.SOUTH_WALL);
        Registry.register(PROPERTY, (String)"wall_height_west", (Object)BlockStateProperties.WEST_WALL);
        Registry.register(PROPERTY, (String)"redstone_east", (Object)BlockStateProperties.EAST_REDSTONE);
        Registry.register(PROPERTY, (String)"redstone_north", (Object)BlockStateProperties.NORTH_REDSTONE);
        Registry.register(PROPERTY, (String)"redstone_south", (Object)BlockStateProperties.SOUTH_REDSTONE);
        Registry.register(PROPERTY, (String)"redstone_west", (Object)BlockStateProperties.WEST_REDSTONE);
        Registry.register(PROPERTY, (String)"double_block_half", (Object)BlockStateProperties.DOUBLE_BLOCK_HALF);
        Registry.register(PROPERTY, (String)"half", (Object)BlockStateProperties.HALF);
        Registry.register(PROPERTY, (String)"side_chain", (Object)BlockStateProperties.SIDE_CHAIN_PART);
        Registry.register(PROPERTY, (String)"rail_shape", (Object)BlockStateProperties.RAIL_SHAPE);
        Registry.register(PROPERTY, (String)"rail_shape_straight", (Object)BlockStateProperties.RAIL_SHAPE_STRAIGHT);
        Registry.register(PROPERTY, (String)"age_0_1", (Object)BlockStateProperties.AGE_1);
        Registry.register(PROPERTY, (String)"age_0_2", (Object)BlockStateProperties.AGE_2);
        Registry.register(PROPERTY, (String)"age_0_3", (Object)BlockStateProperties.AGE_3);
        Registry.register(PROPERTY, (String)"age_0_4", (Object)BlockStateProperties.AGE_4);
        Registry.register(PROPERTY, (String)"age_0_5", (Object)BlockStateProperties.AGE_5);
        Registry.register(PROPERTY, (String)"age_0_7", (Object)BlockStateProperties.AGE_7);
        Registry.register(PROPERTY, (String)"age_0_15", (Object)BlockStateProperties.AGE_15);
        Registry.register(PROPERTY, (String)"age_0_25", (Object)BlockStateProperties.AGE_25);
        Registry.register(PROPERTY, (String)"bites_0_6", (Object)BlockStateProperties.BITES);
        Registry.register(PROPERTY, (String)"candles", (Object)BlockStateProperties.CANDLES);
        Registry.register(PROPERTY, (String)"delay_1_4", (Object)BlockStateProperties.DELAY);
        Registry.register(PROPERTY, (String)"distance_1_7", (Object)BlockStateProperties.DISTANCE);
        Registry.register(PROPERTY, (String)"eggs_1_4", (Object)BlockStateProperties.EGGS);
        Registry.register(PROPERTY, (String)"hatch_0_2", (Object)BlockStateProperties.HATCH);
        Registry.register(PROPERTY, (String)"layers_1_8", (Object)BlockStateProperties.LAYERS);
        Registry.register(PROPERTY, (String)"level_0_3", (Object)BlockStateProperties.LEVEL_CAULDRON);
        Registry.register(PROPERTY, (String)"level_0_8", (Object)BlockStateProperties.LEVEL_COMPOSTER);
        Registry.register(PROPERTY, (String)"level_1_8", (Object)BlockStateProperties.LEVEL_FLOWING);
        Registry.register(PROPERTY, (String)"honey_level", (Object)BlockStateProperties.LEVEL_HONEY);
        Registry.register(PROPERTY, (String)"level_0_15", (Object)BlockStateProperties.LEVEL);
        Registry.register(PROPERTY, (String)"moisture_0_7", (Object)BlockStateProperties.MOISTURE);
        Registry.register(PROPERTY, (String)"note_0_24", (Object)BlockStateProperties.NOTE);
        Registry.register(PROPERTY, (String)"pickles_1_4", (Object)BlockStateProperties.PICKLES);
        Registry.register(PROPERTY, (String)"power_0_15", (Object)BlockStateProperties.POWER);
        Registry.register(PROPERTY, (String)"stage_0_1", (Object)BlockStateProperties.STAGE);
        Registry.register(PROPERTY, (String)"distance_0_7", (Object)BlockStateProperties.STABILITY_DISTANCE);
        Registry.register(PROPERTY, (String)"charges", (Object)BlockStateProperties.RESPAWN_ANCHOR_CHARGES);
        Registry.register(PROPERTY, (String)"hydration", (Object)BlockStateProperties.DRIED_GHAST_HYDRATION_LEVELS);
        Registry.register(PROPERTY, (String)"rotation_0_15", (Object)BlockStateProperties.ROTATION_16);
        Registry.register(PROPERTY, (String)"bed_part", (Object)BlockStateProperties.BED_PART);
        Registry.register(PROPERTY, (String)"chest_type", (Object)BlockStateProperties.CHEST_TYPE);
        Registry.register(PROPERTY, (String)"comparator_mode", (Object)BlockStateProperties.MODE_COMPARATOR);
        Registry.register(PROPERTY, (String)"door_hinge", (Object)BlockStateProperties.DOOR_HINGE);
        Registry.register(PROPERTY, (String)"note_block_instrument", (Object)BlockStateProperties.NOTEBLOCK_INSTRUMENT);
        Registry.register(PROPERTY, (String)"piston_type", (Object)BlockStateProperties.PISTON_TYPE);
        Registry.register(PROPERTY, (String)"slab_type", (Object)BlockStateProperties.SLAB_TYPE);
        Registry.register(PROPERTY, (String)"stairs_shape", (Object)BlockStateProperties.STAIRS_SHAPE);
        Registry.register(PROPERTY, (String)"structure_block_mode", (Object)BlockStateProperties.STRUCTUREBLOCK_MODE);
        Registry.register(PROPERTY, (String)"bamboo_leaves", (Object)BlockStateProperties.BAMBOO_LEAVES);
        Registry.register(PROPERTY, (String)"tilt", (Object)BlockStateProperties.TILT);
        Registry.register(PROPERTY, (String)"vertical_direction", (Object)BlockStateProperties.VERTICAL_DIRECTION);
        Registry.register(PROPERTY, (String)"dripstone_thickness", (Object)BlockStateProperties.DRIPSTONE_THICKNESS);
        Registry.register(PROPERTY, (String)"sculk_sensor_phase", (Object)BlockStateProperties.SCULK_SENSOR_PHASE);
        Registry.register(PROPERTY, (String)"slot_0_occupied", (Object)BlockStateProperties.SLOT_0_OCCUPIED);
        Registry.register(PROPERTY, (String)"slot_1_occupied", (Object)BlockStateProperties.SLOT_1_OCCUPIED);
        Registry.register(PROPERTY, (String)"slot_2_occupied", (Object)BlockStateProperties.SLOT_2_OCCUPIED);
        Registry.register(PROPERTY, (String)"slot_3_occupied", (Object)BlockStateProperties.SLOT_3_OCCUPIED);
        Registry.register(PROPERTY, (String)"slot_4_occupied", (Object)BlockStateProperties.SLOT_4_OCCUPIED);
        Registry.register(PROPERTY, (String)"slot_5_occupied", (Object)BlockStateProperties.SLOT_5_OCCUPIED);
        Registry.register(PROPERTY, (String)"dusted", (Object)BlockStateProperties.DUSTED);
        Registry.register(PROPERTY, (String)"cracked", (Object)BlockStateProperties.CRACKED);
        Registry.register(PROPERTY, (String)"crafting", (Object)BlockStateProperties.CRAFTING);
        Registry.register(PROPERTY, (String)"trial_spawner_state", (Object)BlockStateProperties.TRIAL_SPAWNER_STATE);
        Registry.register(PROPERTY, (String)"vault_state", (Object)BlockStateProperties.VAULT_STATE);
        Registry.register(PROPERTY, (String)"creaking_heart_state", (Object)BlockStateProperties.CREAKING_HEART_STATE);
        Registry.register(PROPERTY, (String)"ominous", (Object)BlockStateProperties.OMINOUS);
        Registry.register(PROPERTY, (String)"mode", (Object)BlockStateProperties.TEST_BLOCK_MODE);
        Registry.register(PROPERTY, (String)"map", (Object)BlockStateProperties.MAP);
        Registry.register(PROPERTY, (String)"copper_golem_pose", (Object)BlockStateProperties.COPPER_GOLEM_POSE);
    }

    private static void registerFoods() {
        Registry.register(FOOD, (String)"apple", (Object)Foods.APPLE);
        Registry.register(FOOD, (String)"baked_potato", (Object)Foods.BAKED_POTATO);
        Registry.register(FOOD, (String)"beef", (Object)Foods.BEEF);
        Registry.register(FOOD, (String)"beetroot", (Object)Foods.BEETROOT);
        Registry.register(FOOD, (String)"beetroot_soup", (Object)Foods.BEETROOT_SOUP);
        Registry.register(FOOD, (String)"bread", (Object)Foods.BREAD);
        Registry.register(FOOD, (String)"carrot", (Object)Foods.CARROT);
        Registry.register(FOOD, (String)"chicken", (Object)Foods.CHICKEN);
        Registry.register(FOOD, (String)"chorus_fruit", (Object)Foods.CHORUS_FRUIT);
        Registry.register(FOOD, (String)"cod", (Object)Foods.COD);
        Registry.register(FOOD, (String)"cooked_beef", (Object)Foods.COOKED_BEEF);
        Registry.register(FOOD, (String)"cooked_chicken", (Object)Foods.COOKED_CHICKEN);
        Registry.register(FOOD, (String)"cooked_cod", (Object)Foods.COOKED_COD);
        Registry.register(FOOD, (String)"cooked_mutton", (Object)Foods.COOKED_MUTTON);
        Registry.register(FOOD, (String)"cooked_porkchop", (Object)Foods.COOKED_PORKCHOP);
        Registry.register(FOOD, (String)"cooked_rabbit", (Object)Foods.COOKED_RABBIT);
        Registry.register(FOOD, (String)"cooked_salmon", (Object)Foods.COOKED_SALMON);
        Registry.register(FOOD, (String)"cookie", (Object)Foods.COOKIE);
        Registry.register(FOOD, (String)"dried_kelp", (Object)Foods.DRIED_KELP);
        Registry.register(FOOD, (String)"enchanted_golden_apple", (Object)Foods.ENCHANTED_GOLDEN_APPLE);
        Registry.register(FOOD, (String)"golden_apple", (Object)Foods.GOLDEN_APPLE);
        Registry.register(FOOD, (String)"golden_carrot", (Object)Foods.GOLDEN_CARROT);
        Registry.register(FOOD, (String)"honey_bottle", (Object)Foods.HONEY_BOTTLE);
        Registry.register(FOOD, (String)"melon_slice", (Object)Foods.MELON_SLICE);
        Registry.register(FOOD, (String)"mushroom_stew", (Object)Foods.MUSHROOM_STEW);
        Registry.register(FOOD, (String)"mutton", (Object)Foods.MUTTON);
        Registry.register(FOOD, (String)"poisonous_potato", (Object)Foods.POISONOUS_POTATO);
        Registry.register(FOOD, (String)"porkchop", (Object)Foods.PORKCHOP);
        Registry.register(FOOD, (String)"potato", (Object)Foods.POTATO);
        Registry.register(FOOD, (String)"pufferfish", (Object)Foods.PUFFERFISH);
        Registry.register(FOOD, (String)"pumpkin_pie", (Object)Foods.PUMPKIN_PIE);
        Registry.register(FOOD, (String)"rabbit", (Object)Foods.RABBIT);
        Registry.register(FOOD, (String)"rabbit_stew", (Object)Foods.RABBIT_STEW);
        Registry.register(FOOD, (String)"rotten_flesh", (Object)Foods.ROTTEN_FLESH);
        Registry.register(FOOD, (String)"salmon", (Object)Foods.SALMON);
        Registry.register(FOOD, (String)"spider_eye", (Object)Foods.SPIDER_EYE);
        Registry.register(FOOD, (String)"suspicious_stew", (Object)Foods.SUSPICIOUS_STEW);
        Registry.register(FOOD, (String)"sweet_berries", (Object)Foods.SWEET_BERRIES);
        Registry.register(FOOD, (String)"glow_berries", (Object)Foods.GLOW_BERRIES);
        Registry.register(FOOD, (String)"tropical_fish", (Object)Foods.TROPICAL_FISH);
    }

    private static void registerSoundTypes() {
        Registry.register(SOUND_TYPE, (String)"wood", (Object)SoundType.WOOD);
        Registry.register(SOUND_TYPE, (String)"gravel", (Object)SoundType.GRAVEL);
        Registry.register(SOUND_TYPE, (String)"grass", (Object)SoundType.GRASS);
        Registry.register(SOUND_TYPE, (String)"lily_pad", (Object)SoundType.LILY_PAD);
        Registry.register(SOUND_TYPE, (String)"stone", (Object)SoundType.STONE);
        Registry.register(SOUND_TYPE, (String)"metal", (Object)SoundType.METAL);
        Registry.register(SOUND_TYPE, (String)"glass", (Object)SoundType.GLASS);
        Registry.register(SOUND_TYPE, (String)"wool", (Object)SoundType.WOOL);
        Registry.register(SOUND_TYPE, (String)"sand", (Object)SoundType.SAND);
        Registry.register(SOUND_TYPE, (String)"snow", (Object)SoundType.SNOW);
        Registry.register(SOUND_TYPE, (String)"powder_snow", (Object)SoundType.POWDER_SNOW);
        Registry.register(SOUND_TYPE, (String)"ladder", (Object)SoundType.LADDER);
        Registry.register(SOUND_TYPE, (String)"anvil", (Object)SoundType.ANVIL);
        Registry.register(SOUND_TYPE, (String)"slime_block", (Object)SoundType.SLIME_BLOCK);
        Registry.register(SOUND_TYPE, (String)"honey_block", (Object)SoundType.HONEY_BLOCK);
        Registry.register(SOUND_TYPE, (String)"wet_grass", (Object)SoundType.WET_GRASS);
        Registry.register(SOUND_TYPE, (String)"coral_block", (Object)SoundType.CORAL_BLOCK);
        Registry.register(SOUND_TYPE, (String)"bamboo", (Object)SoundType.BAMBOO);
        Registry.register(SOUND_TYPE, (String)"bamboo_sapling", (Object)SoundType.BAMBOO_SAPLING);
        Registry.register(SOUND_TYPE, (String)"scaffolding", (Object)SoundType.SCAFFOLDING);
        Registry.register(SOUND_TYPE, (String)"sweet_berry_bush", (Object)SoundType.SWEET_BERRY_BUSH);
        Registry.register(SOUND_TYPE, (String)"crop", (Object)SoundType.CROP);
        Registry.register(SOUND_TYPE, (String)"hard_crop", (Object)SoundType.HARD_CROP);
        Registry.register(SOUND_TYPE, (String)"vine", (Object)SoundType.VINE);
        Registry.register(SOUND_TYPE, (String)"nether_wart", (Object)SoundType.NETHER_WART);
        Registry.register(SOUND_TYPE, (String)"lantern", (Object)SoundType.LANTERN);
        Registry.register(SOUND_TYPE, (String)"stem", (Object)SoundType.STEM);
        Registry.register(SOUND_TYPE, (String)"nylium", (Object)SoundType.NYLIUM);
        Registry.register(SOUND_TYPE, (String)"fungus", (Object)SoundType.FUNGUS);
        Registry.register(SOUND_TYPE, (String)"roots", (Object)SoundType.ROOTS);
        Registry.register(SOUND_TYPE, (String)"shroomlight", (Object)SoundType.SHROOMLIGHT);
        Registry.register(SOUND_TYPE, (String)"weeping_vines", (Object)SoundType.WEEPING_VINES);
        Registry.register(SOUND_TYPE, (String)"twisting_vines", (Object)SoundType.TWISTING_VINES);
        Registry.register(SOUND_TYPE, (String)"soul_sand", (Object)SoundType.SOUL_SAND);
        Registry.register(SOUND_TYPE, (String)"soul_soil", (Object)SoundType.SOUL_SOIL);
        Registry.register(SOUND_TYPE, (String)"basalt", (Object)SoundType.BASALT);
        Registry.register(SOUND_TYPE, (String)"wart_block", (Object)SoundType.WART_BLOCK);
        Registry.register(SOUND_TYPE, (String)"netherrack", (Object)SoundType.NETHERRACK);
        Registry.register(SOUND_TYPE, (String)"nether_bricks", (Object)SoundType.NETHER_BRICKS);
        Registry.register(SOUND_TYPE, (String)"nether_sprouts", (Object)SoundType.NETHER_SPROUTS);
        Registry.register(SOUND_TYPE, (String)"nether_ore", (Object)SoundType.NETHER_ORE);
        Registry.register(SOUND_TYPE, (String)"bone_block", (Object)SoundType.BONE_BLOCK);
        Registry.register(SOUND_TYPE, (String)"netherite_block", (Object)SoundType.NETHERITE_BLOCK);
        Registry.register(SOUND_TYPE, (String)"ancient_debris", (Object)SoundType.ANCIENT_DEBRIS);
        Registry.register(SOUND_TYPE, (String)"lodestone", (Object)SoundType.LODESTONE);
        Registry.register(SOUND_TYPE, (String)"chain", (Object)SoundType.CHAIN);
        Registry.register(SOUND_TYPE, (String)"nether_gold_ore", (Object)SoundType.NETHER_GOLD_ORE);
        Registry.register(SOUND_TYPE, (String)"gilded_blackstone", (Object)SoundType.GILDED_BLACKSTONE);
        Registry.register(SOUND_TYPE, (String)"candle", (Object)SoundType.CANDLE);
        Registry.register(SOUND_TYPE, (String)"amethyst", (Object)SoundType.AMETHYST);
        Registry.register(SOUND_TYPE, (String)"amethyst_cluster", (Object)SoundType.AMETHYST_CLUSTER);
        Registry.register(SOUND_TYPE, (String)"small_amethyst_bud", (Object)SoundType.SMALL_AMETHYST_BUD);
        Registry.register(SOUND_TYPE, (String)"medium_amethyst_bud", (Object)SoundType.MEDIUM_AMETHYST_BUD);
        Registry.register(SOUND_TYPE, (String)"large_amethyst_bud", (Object)SoundType.LARGE_AMETHYST_BUD);
        Registry.register(SOUND_TYPE, (String)"tuff", (Object)SoundType.TUFF);
        Registry.register(SOUND_TYPE, (String)"calcite", (Object)SoundType.CALCITE);
        Registry.register(SOUND_TYPE, (String)"dripstone_block", (Object)SoundType.DRIPSTONE_BLOCK);
        Registry.register(SOUND_TYPE, (String)"pointed_dripstone", (Object)SoundType.POINTED_DRIPSTONE);
        Registry.register(SOUND_TYPE, (String)"copper", (Object)SoundType.COPPER);
        Registry.register(SOUND_TYPE, (String)"cave_vines", (Object)SoundType.CAVE_VINES);
        Registry.register(SOUND_TYPE, (String)"spore_blossom", (Object)SoundType.SPORE_BLOSSOM);
        Registry.register(SOUND_TYPE, (String)"azalea", (Object)SoundType.AZALEA);
        Registry.register(SOUND_TYPE, (String)"flowering_azalea", (Object)SoundType.FLOWERING_AZALEA);
        Registry.register(SOUND_TYPE, (String)"moss_carpet", (Object)SoundType.MOSS_CARPET);
        Registry.register(SOUND_TYPE, (String)"pink_petals", (Object)SoundType.PINK_PETALS);
        Registry.register(SOUND_TYPE, (String)"moss", (Object)SoundType.MOSS);
        Registry.register(SOUND_TYPE, (String)"big_dripleaf", (Object)SoundType.BIG_DRIPLEAF);
        Registry.register(SOUND_TYPE, (String)"small_dripleaf", (Object)SoundType.SMALL_DRIPLEAF);
        Registry.register(SOUND_TYPE, (String)"rooted_dirt", (Object)SoundType.ROOTED_DIRT);
        Registry.register(SOUND_TYPE, (String)"hanging_roots", (Object)SoundType.HANGING_ROOTS);
        Registry.register(SOUND_TYPE, (String)"azalea_leaves", (Object)SoundType.AZALEA_LEAVES);
        Registry.register(SOUND_TYPE, (String)"sculk_sensor", (Object)SoundType.SCULK_SENSOR);
        Registry.register(SOUND_TYPE, (String)"sculk_catalyst", (Object)SoundType.SCULK_CATALYST);
        Registry.register(SOUND_TYPE, (String)"sculk", (Object)SoundType.SCULK);
        Registry.register(SOUND_TYPE, (String)"sculk_vein", (Object)SoundType.SCULK_VEIN);
        Registry.register(SOUND_TYPE, (String)"sculk_shrieker", (Object)SoundType.SCULK_SHRIEKER);
        Registry.register(SOUND_TYPE, (String)"glow_lichen", (Object)SoundType.GLOW_LICHEN);
        Registry.register(SOUND_TYPE, (String)"deepslate", (Object)SoundType.DEEPSLATE);
        Registry.register(SOUND_TYPE, (String)"deepslate_bricks", (Object)SoundType.DEEPSLATE_BRICKS);
        Registry.register(SOUND_TYPE, (String)"deepslate_tiles", (Object)SoundType.DEEPSLATE_TILES);
        Registry.register(SOUND_TYPE, (String)"polished_deepslate", (Object)SoundType.POLISHED_DEEPSLATE);
        Registry.register(SOUND_TYPE, (String)"froglight", (Object)SoundType.FROGLIGHT);
        Registry.register(SOUND_TYPE, (String)"frogspawn", (Object)SoundType.FROGSPAWN);
        Registry.register(SOUND_TYPE, (String)"mangrove_roots", (Object)SoundType.MANGROVE_ROOTS);
        Registry.register(SOUND_TYPE, (String)"muddy_mangrove_roots", (Object)SoundType.MUDDY_MANGROVE_ROOTS);
        Registry.register(SOUND_TYPE, (String)"mud", (Object)SoundType.MUD);
        Registry.register(SOUND_TYPE, (String)"mud_bricks", (Object)SoundType.MUD_BRICKS);
        Registry.register(SOUND_TYPE, (String)"packed_mud", (Object)SoundType.PACKED_MUD);
        Registry.register(SOUND_TYPE, (String)"hanging_sign", (Object)SoundType.HANGING_SIGN);
        Registry.register(SOUND_TYPE, (String)"nether_wood_hanging_sign", (Object)SoundType.NETHER_WOOD_HANGING_SIGN);
        Registry.register(SOUND_TYPE, (String)"bamboo_wood_hanging_sign", (Object)SoundType.BAMBOO_WOOD_HANGING_SIGN);
        Registry.register(SOUND_TYPE, (String)"bamboo_wood", (Object)SoundType.BAMBOO_WOOD);
        Registry.register(SOUND_TYPE, (String)"nether_wood", (Object)SoundType.NETHER_WOOD);
        Registry.register(SOUND_TYPE, (String)"cherry_wood", (Object)SoundType.CHERRY_WOOD);
        Registry.register(SOUND_TYPE, (String)"cherry_sapling", (Object)SoundType.CHERRY_SAPLING);
        Registry.register(SOUND_TYPE, (String)"cherry_leaves", (Object)SoundType.CHERRY_LEAVES);
        Registry.register(SOUND_TYPE, (String)"cherry_wood_hanging_sign", (Object)SoundType.CHERRY_WOOD_HANGING_SIGN);
        Registry.register(SOUND_TYPE, (String)"chiseled_bookshelf", (Object)SoundType.CHISELED_BOOKSHELF);
        Registry.register(SOUND_TYPE, (String)"suspicious_sand", (Object)SoundType.SUSPICIOUS_SAND);
        Registry.register(SOUND_TYPE, (String)"decorated_pot", (Object)SoundType.DECORATED_POT);
    }

    static {
        ThingRegistries.registerToolMaterials();
        ThingRegistries.registerArmorMaterials();
        ThingRegistries.registerFoods();
        ThingRegistries.registerProperties();
        ThingRegistries.registerDynamicShapes();
        ThingRegistries.registerSoundTypes();
        PropertyTypes.init();
        FlexBlockType.init();
        FlexItemType.init();
        MapColors.init();
        FlexFluidType.init();
    }
}

