/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import net.minecraft.resources.Identifier;
import net.minecraft.world.food.FoodProperties;

public class FoodPropertiesBuilder
extends BaseBuilder<FoodProperties, FoodPropertiesBuilder> {
    private int nutrition;
    private float saturation;
    private boolean alwaysEat;

    public static FoodPropertiesBuilder begin(ThingParser<FoodProperties, FoodPropertiesBuilder> ownerParser, Identifier registryName) {
        return new FoodPropertiesBuilder(ownerParser, registryName);
    }

    private FoodPropertiesBuilder(ThingParser<FoodProperties, FoodPropertiesBuilder> ownerParser, Identifier registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Food Definition";
    }

    public void setNutrition(int num) {
        this.nutrition = num;
    }

    public void setSaturation(float num) {
        this.saturation = num;
    }

    public void setAlwaysEat(boolean alwaysEat) {
        this.alwaysEat = alwaysEat;
    }

    @Override
    protected FoodProperties buildInternal() {
        FoodProperties.Builder foodBuilder = new FoodProperties.Builder();
        foodBuilder.nutrition(this.nutrition);
        foodBuilder.saturationModifier(this.saturation);
        if (this.alwaysEat) {
            foodBuilder.alwaysEdible();
        }
        return foodBuilder.build();
    }

    @Override
    public void validate() {
    }
}

