/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodPropertiesBuilder;
import dev.gigaherz.jsonthings.things.events.IEventRunner;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.IItemFactory;
import dev.gigaherz.jsonthings.things.serializers.ItemVariantProvider;
import dev.gigaherz.jsonthings.util.Utils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends BaseBuilder<Item, ItemBuilder>
implements ItemVariantProvider {
    private final Map<EquipmentSlotGroup, Multimap<Identifier, AttributeModifier>> attributeModifiers = Maps.newHashMap();
    private FlexItemType<?> itemType;
    private Integer maxStackSize = null;
    private Integer maxDamage = null;
    private Boolean isFireResistant;
    private ResourceKey<CreativeModeTab> group = null;
    private final Multimap<ResourceKey<CreativeModeTab>, StackContext> creativeMenuStacks = ArrayListMultimap.create();
    private Supplier<@NotNull FoodProperties> foodDefinition = null;
    public Integer useTime = null;
    public ItemUseAnimation useAnim = null;
    public UseFinishMode useFinishMode = null;
    private Identifier containerItem = null;
    private String colorHandler = null;
    private String[] toolActions;
    private List<Component> lore;
    private JsonObject components;
    private IItemFactory<? extends Item> factory;
    private Queue<Holder> validationPending = new ArrayDeque<Holder>();

    public static ItemBuilder begin(ThingParser<Item, ItemBuilder> ownerParser, Identifier registryName) {
        return new ItemBuilder(ownerParser, registryName);
    }

    private ItemBuilder(ThingParser<Item, ItemBuilder> ownerParser, Identifier registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Item";
    }

    public void setType(String typeName) {
        if (this.itemType != null) {
            throw new RuntimeException("Item type already set.");
        }
        this.itemType = (FlexItemType)ThingRegistries.ITEM_TYPE.getOptional(Identifier.parse((String)typeName)).orElseThrow(() -> new IllegalStateException("No known block type with name " + typeName));
    }

    public void setType(FlexItemType<?> type) {
        if (ThingRegistries.ITEM_TYPE.getKey(type) == null) {
            throw new IllegalStateException("Item type not registered!");
        }
        this.itemType = type;
    }

    public void setMaxStackSize(int maxStackSize) {
        if (this.maxStackSize != null) {
            throw new RuntimeException("Max stack size already set.");
        }
        this.maxStackSize = maxStackSize;
    }

    public void setGroup(Identifier group) {
        if (!this.creativeMenuStacks.isEmpty()) {
            throw new RuntimeException("Creative menu stacks have been added, do not call setGroup if you intend on adding creative menu stacks.");
        }
        this.group = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (Identifier)group);
    }

    public void withCreativeMenuStack(StackContext stackContext, Identifier[] tabs) {
        if (this.group != null) {
            throw new RuntimeException("An item group name has been defined, do not call setGroup if you intend on adding creative menu stacks.");
        }
        for (Identifier tab : tabs) {
            this.creativeMenuStacks.put((Object)ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (Identifier)tab), (Object)stackContext);
        }
    }

    public void withAttributeModifier(EquipmentSlotGroup slot, Identifier attribute, Identifier id, double amount, AttributeModifier.Operation op) {
        AttributeModifier mod = new AttributeModifier(id, amount, op);
        this.attributeModifiers.computeIfAbsent(slot, _slot -> ArrayListMultimap.create()).put((Object)attribute, (Object)mod);
    }

    public void setMaxDamage(int maxDamage) {
        if (this.maxDamage != null) {
            throw new RuntimeException("Damageable already set.");
        }
        this.maxDamage = maxDamage;
    }

    public void setFireResistant(boolean isFireResistant) {
        this.isFireResistant = isFireResistant;
    }

    public void setFood(Identifier foodName) {
        if (this.foodDefinition != null) {
            throw new RuntimeException("Food info already set.");
        }
        this.foodDefinition = () -> ThingRegistries.FOOD.getOptional(foodName).orElseGet(() -> (FoodProperties)((FoodPropertiesBuilder)JsonThings.foodPropertiesParser.getOrCrash(foodName)).get());
    }

    public void setFood(FoodProperties food) {
        if (this.foodDefinition != null) {
            throw new RuntimeException("Food info already set.");
        }
        this.foodDefinition = () -> food;
    }

    public void setUseTime(int useTime) {
        this.useTime = useTime;
    }

    public void setUseAnim(ItemUseAnimation useAnim) {
        this.useAnim = useAnim;
    }

    public void setUseFinishMode(UseFinishMode finishMode) {
        this.useFinishMode = finishMode;
    }

    public void setContainerItem(Identifier resourceLocation) {
        if (this.containerItem != null) {
            throw new RuntimeException("Container Item already set.");
        }
        this.containerItem = resourceLocation;
    }

    public void setToolActions(String[] stringValues) {
        this.toolActions = stringValues;
    }

    public void setColorHandler(String colorHandler) {
        this.colorHandler = colorHandler;
    }

    public void setLore(List<Component> lore) {
        this.lore = lore;
    }

    public void setComponents(JsonObject dataComponentPatch) {
        this.components = dataComponentPatch;
    }

    @Override
    protected Item buildInternal() {
        Item item;
        JsonObject components;
        Boolean fr;
        Supplier<FoodProperties> foodDefinition;
        Identifier ci;
        Integer md;
        Item.Properties properties = new Item.Properties();
        properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)this.getRegistryName()));
        Integer ms = this.getMaxStackSize();
        if (ms != null) {
            properties = properties.stacksTo(ms.intValue());
        }
        if ((md = this.getMaxDamage()) != null) {
            properties = properties.durability(md.intValue());
        }
        if ((ci = this.getContainerItem()) != null) {
            properties = properties.craftRemainder((Item)Utils.getOrCrash(BuiltInRegistries.ITEM, ci));
        }
        if ((foodDefinition = this.getFoodDefinition()) != null) {
            properties = properties.food(foodDefinition.get());
        }
        if ((fr = this.getIsFireResistant()) != null && fr.booleanValue()) {
            properties = properties.fireResistant();
        }
        if ((components = this.getComponents()) != null) {
            DataComponentPatch parsedComponents = this.parseDataComponents(components);
            Item.Properties props = properties;
            for (Map.Entry entry : parsedComponents.entrySet()) {
                DataComponentType key = (DataComponentType)entry.getKey();
                ((Optional)entry.getValue()).ifPresent(value -> props.component(key, value));
            }
        }
        if ((item = this.factory.construct(properties, this)) instanceof IEventRunner) {
            IEventRunner eventRunner = (IEventRunner)item;
            this.constructEventHandlers(eventRunner);
        }
        return item;
    }

    private DataComponentPatch parseDataComponents(JsonObject components) {
        return (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (RegistryOps.RegistryInfoLookup)this.getLookup()), (Object)components).getOrThrow()).getFirst();
    }

    private RegistryOps.RegistryInfoLookup getLookup() {
        return new RegistryOps.RegistryInfoLookup(){
            private final Reference2ObjectMap<ResourceKey, Pair<Registry, HolderGetter>> registriesMap = new Reference2ObjectArrayMap();

            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> registryKey) {
                Pair pair = (Pair)this.registriesMap.computeIfAbsent(registryKey, key -> {
                    Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValueOrThrow(registryKey);
                    HolderGetter holdergetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)registry);
                    return Pair.of((Object)registry, (Object)holdergetter);
                });
                final Registry registry = (Registry)pair.getFirst();
                final HolderGetter holdergetter = (HolderGetter)pair.getSecond();
                return Optional.of(new RegistryOps.RegistryInfo((HolderOwner)registry, new HolderGetter<T>(){

                    public Optional<Holder.Reference<T>> get(ResourceKey<T> resourceKey) {
                        return registry.getOptional(resourceKey).map(obj -> (Holder.Reference)registry.wrapAsHolder(obj)).or(() -> {
                            DeferredHolder holder1 = DeferredHolder.create((ResourceKey)resourceKey);
                            ItemBuilder.this.validationPending.add((Holder)holder1);
                            return Optional.of(ItemBuilder.this.wrapAsReference(registry, holder1));
                        });
                    }

                    public Optional<HolderSet.Named<T>> get(TagKey tagKey) {
                        return holdergetter.get(tagKey);
                    }
                }, registry.registryLifecycle()));
            }
        };
    }

    private <T> Holder.Reference<T> wrapAsReference(HolderOwner<T> owner, final DeferredHolder<T, T> holder1) {
        return new Holder.Reference<T>(this, Holder.Reference.Type.STAND_ALONE, owner, holder1.getKey(), null){

            public ResourceKey<T> key() {
                return holder1.getKey();
            }

            public T value() {
                return holder1.value();
            }
        };
    }

    @Override
    public void provideVariants(ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.Output output, CreativeModeTab.ItemDisplayParameters parameters, @Nullable ItemBuilder _context, boolean explicit) {
        ItemBuilder context = Objects.requireNonNullElse(_context, this);
        if (explicit) {
            this.factory.provideVariants(tabKey, output, parameters, context, explicit);
        } else if (this.group != null) {
            if (this.group.equals(tabKey)) {
                this.factory.provideVariants(tabKey, output, parameters, context, explicit);
            }
        } else if (!this.creativeMenuStacks.isEmpty()) {
            this.creativeMenuStacks.get(tabKey).forEach(stack -> output.accept(stack.toStack((Item)context.get())));
        } else if (this.getParent() != null) {
            ((ItemBuilder)this.getParent()).provideVariants(tabKey, output, parameters, context, explicit);
        }
    }

    @Nullable
    public Integer getMaxDamage() {
        return this.getValue(this.maxDamage, ItemBuilder::getMaxDamage);
    }

    @Nullable
    public Integer getMaxStackSize() {
        return this.getValue(this.maxStackSize, ItemBuilder::getMaxStackSize);
    }

    @Nullable
    public Boolean getIsFireResistant() {
        return this.getValue(this.isFireResistant, ItemBuilder::getIsFireResistant);
    }

    @Nullable
    public Identifier getContainerItem() {
        return this.getValue(this.containerItem, ItemBuilder::getContainerItem);
    }

    public @Nullable Supplier<@NotNull FoodProperties> getFoodDefinition() {
        return this.getValue(this.foodDefinition, ItemBuilder::getFoodDefinition);
    }

    @Nullable
    public FlexItemType<?> getTypeRaw() {
        return this.getValue(this.itemType, ItemBuilder::getTypeRaw);
    }

    public FlexItemType<?> getType() {
        return Utils.orElse(this.getTypeRaw(), FlexItemType.PLAIN);
    }

    public boolean hasType() {
        return this.getValueOrElse(this.itemType != null, ItemBuilder::hasType, false);
    }

    @Nullable
    public String getColorHandler() {
        return this.getValue(this.colorHandler, ItemBuilder::getColorHandler);
    }

    public void setFactory(IItemFactory<?> factory) {
        this.factory = factory;
    }

    @Nullable
    public ItemUseAnimation getUseAnim() {
        return this.getValue(this.useAnim, ItemBuilder::getUseAnim);
    }

    @Nullable
    public Integer getUseTime() {
        return this.getValue(this.useTime, ItemBuilder::getUseTime);
    }

    @Nullable
    public UseFinishMode getUseFinishMode() {
        return this.getValue(this.useFinishMode, ItemBuilder::getUseFinishMode);
    }

    @Nullable
    public List<Component> getLore() {
        return this.getValueOrElseGet(this.lore, ItemBuilder::getLore, List::of);
    }

    public ItemAttributeModifiers getAttributeModifiers() {
        Map<EquipmentSlotGroup, Multimap<Identifier, AttributeModifier>> mods = this.getAttributeModifiersRaw();
        if (mods == null) {
            return ItemAttributeModifiers.EMPTY;
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (Map.Entry<EquipmentSlotGroup, Multimap<Identifier, AttributeModifier>> slotEntries : mods.entrySet()) {
            for (Map.Entry attributeEntries : slotEntries.getValue().entries()) {
                DeferredHolder attr = DeferredHolder.create((ResourceKey)Registries.ATTRIBUTE, (Identifier)((Identifier)attributeEntries.getKey()));
                this.validationPending.add((Holder)attr);
                builder.add((Holder)attr, (AttributeModifier)attributeEntries.getValue(), slotEntries.getKey());
            }
        }
        return builder.build();
    }

    @Nullable
    private Map<EquipmentSlotGroup, Multimap<Identifier, AttributeModifier>> getAttributeModifiersRaw() {
        return this.getValue(this.attributeModifiers, ItemBuilder::getAttributeModifiersRaw);
    }

    @Nullable
    public String[] getToolActionsRaw() {
        return this.getValue(this.toolActions, ItemBuilder::getToolActionsRaw);
    }

    @Nullable
    public Set<ItemAbility> getToolActions() {
        String[] raw = this.getToolActionsRaw();
        if (raw == null) {
            return null;
        }
        return Arrays.stream(raw).map(ItemAbility::get).collect(Collectors.toSet());
    }

    @Nullable
    public JsonObject getComponents() {
        return this.getValue(this.components, ItemBuilder::getComponents);
    }

    @Override
    public void validate() {
        while (!this.validationPending.isEmpty()) {
            Holder holder = this.validationPending.remove();
            holder.value();
        }
    }
}

