/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodPropertiesBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.effect.MobEffectInstance;

public class MobEffectInstanceBuilder
extends BaseBuilder<MobEffectInstance, MobEffectInstanceBuilder> {
    private Identifier effect;
    private int duration;
    private int amplifier = 0;
    private boolean isAmbient = false;
    private boolean showParticles = true;
    private boolean showIcon = true;
    private FoodPropertiesBuilder owner;

    public MobEffectInstanceBuilder(ThingParser<MobEffectInstance, MobEffectInstanceBuilder> ownerParser, Identifier name) {
        super(ownerParser, name);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Mob Effect Instance";
    }

    @Override
    protected CrashReportCategory fillReport(CrashReport crashReport) {
        CrashReportCategory reportCategory = super.fillReport(crashReport);
        reportCategory.setDetail("Contained in", (Object)this.owner.getThingTypeDisplayName());
        return reportCategory;
    }

    public void setOwner(FoodPropertiesBuilder owner) {
        this.owner = owner;
    }

    public FoodPropertiesBuilder getOwner() {
        return this.owner;
    }

    public Identifier getEffect() {
        return this.effect;
    }

    public void setEffect(Identifier effect) {
        this.effect = effect;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setAmbient(boolean ambient) {
        this.isAmbient = ambient;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public void setVisible(boolean visible) {
        this.showParticles = this.showIcon = visible;
    }

    @Override
    protected MobEffectInstance buildInternal() {
        return new MobEffectInstance(Utils.getHolderOrCrash(BuiltInRegistries.MOB_EFFECT, this.effect), this.duration, this.amplifier, this.isAmbient, this.showParticles, this.showIcon);
    }

    @Override
    public void validate() {
    }
}

