/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.events;

import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface IEventRunner {
    public <T> void addEventHandler(FlexEventType<T> var1, FlexEventHandler<T> var2);

    @Nullable
    public <T> FlexEventHandler<T> getEventHandler(FlexEventType<T> var1);

    default public void runEvent(FlexEventType<Void> event, FlexEventContext context, Runnable defaultValue) {
        this.runEvent(event, context, () -> {
            defaultValue.run();
            return null;
        });
    }

    default public <T> T runEvent(FlexEventType<T> event, FlexEventContext context, Supplier<T> defaultValue) {
        FlexEventHandler<T> handler = this.getEventHandler(event);
        if (handler != null) {
            return handler.apply(event, context);
        }
        return defaultValue.get();
    }

    default public <T> T runEventThrowing(FlexEventType<T> event, FlexEventContext context, Callable<T> defaultValue) throws Exception {
        FlexEventHandler<T> handler = this.getEventHandler(event);
        if (handler != null) {
            return handler.apply(event, context);
        }
        return defaultValue.call();
    }
}

