/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.properties;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomProperty
extends Property<String> {
    private final ImmutableList<String> allowedValues;

    protected CustomProperty(String name, ImmutableList<String> values) {
        super(name, String.class);
        this.allowedValues = values;
    }

    public List<String> getPossibleValues() {
        return this.allowedValues;
    }

    public String getName(String value) {
        return value;
    }

    public Optional<String> getValue(String value) {
        return this.allowedValues.stream().filter(s -> s.equals(value)).findFirst();
    }

    public int getInternalIndex(String value) {
        return this.allowedValues.indexOf((Object)value);
    }

    public static CustomProperty create(String name, String ... values) {
        return new CustomProperty(name, (ImmutableList<String>)ImmutableList.copyOf((Object[])values));
    }

    public static CustomProperty create(String name, Collection<String> values) {
        return new CustomProperty(name, (ImmutableList<String>)ImmutableList.copyOf(values));
    }
}

