/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util.parse;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.util.parse.JParseException;
import dev.gigaherz.jsonthings.util.parse.MappedArray;
import dev.gigaherz.jsonthings.util.parse.function.IntObjBiConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonArrayConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonElementConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonObjectConsumer;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.ArrayValue;
import dev.gigaherz.jsonthings.util.parse.value.BooleanValue;
import dev.gigaherz.jsonthings.util.parse.value.DoubleValue;
import dev.gigaherz.jsonthings.util.parse.value.FloatValue;
import dev.gigaherz.jsonthings.util.parse.value.IntValue;
import dev.gigaherz.jsonthings.util.parse.value.LongValue;
import dev.gigaherz.jsonthings.util.parse.value.MappedArrayValue;
import dev.gigaherz.jsonthings.util.parse.value.MappedValue;
import dev.gigaherz.jsonthings.util.parse.value.NumberConsumer;
import dev.gigaherz.jsonthings.util.parse.value.NumberValue;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import dev.gigaherz.jsonthings.util.parse.value.StringAnyConsumer;
import dev.gigaherz.jsonthings.util.parse.value.StringValue;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Util;

public class JParse
implements Any,
ObjValue,
ArrayValue,
StringValue,
NumberValue,
FloatValue,
DoubleValue,
IntValue,
LongValue,
BooleanValue {
    private final String path;
    private final JsonElement data;
    private final List<String> altTypes = new ArrayList<String>();
    private boolean handledType = false;
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^-?[0-9]+$");
    private static final Pattern FLOAT = Pattern.compile("^-?(([0-9]+)|([0-9]*\\.[0-9]+))([eEfFdD][+-]?[0-9]+)$");
    private static final Pattern SIMPLE_IDENT = Pattern.compile("^[a-zA-Z0-9_]+$");

    public JParse(String path, JsonElement data) {
        this.path = path;
        this.data = data;
    }

    public static Any begin(JsonElement data) {
        return new JParse("$", data);
    }

    public static ObjValue begin(JsonObject data) {
        return new JParse("$", (JsonElement)data).obj();
    }

    public static ArrayValue begin(JsonArray data) {
        return new JParse("$", (JsonElement)data).array();
    }

    private String formatAltTypes(String and) {
        if (this.altTypes.size() > 0) {
            return String.join((CharSequence)", ", this.altTypes) + ", or " + and;
        }
        return and;
    }

    private String formatAltTypes() {
        if (this.altTypes.size() > 0) {
            return String.join((CharSequence)", ", this.altTypes);
        }
        throw new JParseException("IMPLEMENTATION ERROR: typeError() called without having used any ifType() methods! Please report to the author asap!");
    }

    @Override
    public ObjValue obj() {
        if (!this.data.isJsonObject()) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Json Object"));
        }
        return this;
    }

    @Override
    public ArrayValue array() {
        if (!this.data.isJsonArray()) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Json Array"));
        }
        return this;
    }

    @Override
    public StringValue string() {
        if (!GsonHelper.isStringValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a String"));
        }
        return this;
    }

    @Override
    public NumberValue number() {
        if (!GsonHelper.isNumberValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Number"));
        }
        return this;
    }

    @Override
    public IntValue intValue() {
        if (!GsonHelper.isNumberValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("an Integer"));
        }
        return this;
    }

    @Override
    public LongValue longValue() {
        if (!GsonHelper.isNumberValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Long Integer"));
        }
        return this;
    }

    @Override
    public FloatValue floatValue() {
        if (!GsonHelper.isNumberValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Float"));
        }
        return this;
    }

    @Override
    public DoubleValue doubleValue() {
        if (!GsonHelper.isNumberValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Double"));
        }
        return this;
    }

    @Override
    public BooleanValue bool() {
        if (!GsonHelper.isBooleanValue((JsonElement)this.data)) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes("a Boolean"));
        }
        return this;
    }

    @Override
    public void typeError() {
        if (!this.handledType) {
            throw new JParseException("Value at '" + this.path + "' must be " + this.formatAltTypes());
        }
    }

    @Override
    public Any ifObj(Consumer<ObjValue> visitor) {
        this.altTypes.add("a Json Object");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonObject()) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifArray(Consumer<ArrayValue> visitor) {
        this.altTypes.add("a Json Array");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonArray()) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifString(Consumer<StringValue> visitor) {
        this.altTypes.add("aString");
        if (this.handledType) {
            return this;
        }
        if (GsonHelper.isStringValue((JsonElement)this.data)) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifNumber(Consumer<NumberValue> visitor) {
        this.altTypes.add("a Number");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonPrimitive() && this.data.getAsJsonPrimitive().isNumber()) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifInteger(Consumer<IntValue> visitor) {
        Number number;
        this.altTypes.add("an Integer");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonPrimitive() && this.data.getAsJsonPrimitive().isNumber() && this.isNumberInt(number = this.data.getAsNumber())) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifLong(Consumer<LongValue> visitor) {
        Number number;
        this.altTypes.add("a Long Integer");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonPrimitive() && this.data.getAsJsonPrimitive().isNumber() && this.isNumberLong(number = this.data.getAsNumber())) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifFloat(Consumer<FloatValue> visitor) {
        Number number;
        this.altTypes.add("a Float");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonPrimitive() && this.data.getAsJsonPrimitive().isNumber() && this.isNumberFloat(number = this.data.getAsNumber())) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifDouble(Consumer<DoubleValue> visitor) {
        Number number;
        this.altTypes.add("a Double");
        if (this.handledType) {
            return this;
        }
        if (this.data.isJsonPrimitive() && this.data.getAsJsonPrimitive().isNumber() && this.isNumberDouble(number = this.data.getAsNumber())) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    @Override
    public Any ifBool(Consumer<BooleanValue> visitor) {
        this.altTypes.add("a Boolean");
        if (this.handledType) {
            return this;
        }
        if (GsonHelper.isBooleanValue((JsonElement)this.data)) {
            this.handledType = true;
            try {
                visitor.accept(this);
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + this.path, e);
            }
        }
        return this;
    }

    private boolean isNumberInt(Number number) {
        String text = number.toString();
        if (INTEGER_PATTERN.matcher(text).matches()) {
            long num = Long.parseLong(text);
            return num >= Integer.MIN_VALUE && num <= Integer.MAX_VALUE;
        }
        return false;
    }

    private boolean isNumberLong(Number number) {
        String text = number.toString();
        if (INTEGER_PATTERN.matcher(text).matches()) {
            BigInteger num = new BigInteger(text);
            return num.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && num.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0;
        }
        return false;
    }

    private boolean isNumberFloat(Number number) {
        String text = number.toString();
        if (FLOAT.matcher(text).matches()) {
            double num = Double.parseDouble(text);
            return (double)((float)num) == num;
        }
        return false;
    }

    private boolean isNumberDouble(Number number) {
        String text = number.toString();
        if (FLOAT.matcher(text).matches()) {
            BigDecimal num = new BigDecimal(text);
            return num.compareTo(BigDecimal.valueOf(-1.7976931348623157E308)) >= 0 && num.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0;
        }
        return false;
    }

    @Override
    public void raw(JsonElementConsumer visitor) {
        visitor.accept(this.data);
    }

    @Override
    public JsonElement get() {
        return this.data;
    }

    @Override
    public ObjValue key(String keyName, Consumer<Any> visitor) {
        JsonObject obj = this.getAsJsonObject();
        if (!obj.has(keyName)) {
            throw new JParseException("Json Object at '" + this.path + "' must contain a key with name '" + keyName + "'.");
        }
        String keyPath = this.path + this.wrapName(keyName);
        try {
            visitor.accept(new JParse(keyPath, obj.get(keyName)));
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running visitor for " + keyPath + ": " + e.getMessage(), e);
        }
        return this;
    }

    @Override
    public ObjValue ifKey(String keyName, Consumer<Any> visitor) {
        JsonObject obj = this.getAsJsonObject();
        if (obj.has(keyName)) {
            String keyPath = this.path + this.wrapName(keyName);
            try {
                visitor.accept(new JParse(keyPath, obj.get(keyName)));
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + keyPath + ": " + e.getMessage(), e);
            }
        }
        return this;
    }

    @Override
    public void forEach(StringAnyConsumer visitor) {
        JsonObject obj = this.getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            String keyName = (String)entry.getKey();
            String keyPath = this.path + this.wrapName(keyName);
            visitor.accept(keyName, new JParse(keyPath, (JsonElement)entry.getValue()));
        }
    }

    @Override
    public boolean hasKey(String keyName) {
        return this.getAsJsonObject().has(keyName);
    }

    @Override
    public JsonObject getAsJsonObject() {
        return this.data.getAsJsonObject();
    }

    private String wrapName(String keyName) {
        if (SIMPLE_IDENT.matcher(keyName).matches()) {
            return "." + keyName;
        }
        return "[\"" + keyName.replace("\"", "\\\"") + "\"]";
    }

    @Override
    public void raw(JsonObjectConsumer value) {
        try {
            value.accept(this.getAsJsonObject());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void forEach(IntObjBiConsumer<Any> visitor) {
        JsonArray arr = this.getAsJsonArray();
        for (int i = 0; i < arr.size(); ++i) {
            String entryPath = this.path + "[" + i + "]";
            try {
                visitor.accept(i, new JParse(entryPath, arr.get(i)));
                continue;
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + entryPath, e);
            }
        }
    }

    @Override
    public void collect(Consumer<Stream<Any>> collector) {
        JsonArray arr = this.getAsJsonArray();
        collector.accept(IntStream.range(0, arr.size()).mapToObj(i -> {
            String entryPath = this.path + "[" + i + "]";
            try {
                return new JParse(entryPath, arr.get(i));
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + entryPath, e);
            }
        }));
    }

    public <M> MappedArrayValue<M> map(Function<Any, M> mapping) {
        List items = (List)Util.make(new ArrayList(), list -> {
            for (JsonElement e : this.data.getAsJsonArray()) {
                list.add(mapping.apply(new JParse("", e)));
            }
        });
        return new MappedArray(this.path, items);
    }

    @Override
    public <T> T flatMap(Function<Stream<Any>, T> collector) {
        JsonArray arr = this.getAsJsonArray();
        return collector.apply(IntStream.range(0, arr.size()).mapToObj(i -> {
            String entryPath = this.path + "[" + i + "]";
            try {
                return new JParse(entryPath, arr.get(i));
            }
            catch (Exception e) {
                if (e instanceof JParseException) {
                    throw e;
                }
                throw new JParseException("Error running visitor for " + entryPath, e);
            }
        }));
    }

    @Override
    public void raw(JsonArrayConsumer value) {
        try {
            value.accept(this.getAsJsonArray());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path + ": " + e.getMessage(), e);
        }
    }

    @Override
    public ArrayValue notEmpty() {
        JsonArray arr = this.getAsJsonArray();
        if (arr.size() == 0) {
            throw new JParseException("Json Array at '" + this.path + "' must not be empty.");
        }
        return this;
    }

    @Override
    public ArrayValue atLeast(int min) {
        JsonArray arr = this.getAsJsonArray();
        if (arr.size() < min) {
            throw new JParseException("Json Array at '" + this.path + "' must contain at least " + min + ".");
        }
        return this;
    }

    @Override
    public ArrayValue between(int min, int maxExclusive) {
        JsonArray arr = this.getAsJsonArray();
        if (arr.size() < min) {
            throw new JParseException("Json Array at '" + this.path + "' must contain at least " + min + ".");
        }
        return this;
    }

    @Override
    public <T> MappedValue<T[]> flatten(Function<Any, T> mapping, IntFunction<T[]> factory) {
        return new MappedValue.Impl<T[]>(this.flatMap(items -> items.map(mapping).toArray(factory)));
    }

    @Override
    public JsonArray getAsJsonArray() {
        return this.data.getAsJsonArray();
    }

    @Override
    public void handle(Consumer<String> value) {
        try {
            value.accept(this.getAsString());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public String getAsString() {
        return this.data.getAsJsonPrimitive().getAsString();
    }

    @Override
    public void handle(FloatConsumer value) {
        value.accept(this.getAsFloat());
    }

    @Override
    public FloatValue min(float min) {
        float val = this.getAsFloat();
        if (val < min) {
            throw new JParseException("Value at '" + this.path + "' must be " + min + " or bigger.");
        }
        return this;
    }

    @Override
    public FloatValue range(float min, float maxExclusive) {
        float val = this.getAsFloat();
        if (val < min || val >= maxExclusive) {
            throw new JParseException("Value at '" + this.path + "' must be between " + min + " and " + maxExclusive + " (exclusive).");
        }
        return this;
    }

    @Override
    public float getAsFloat() {
        return this.data.getAsJsonPrimitive().getAsFloat();
    }

    @Override
    public void handle(DoubleConsumer value) {
        try {
            value.accept(this.getAsDouble());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public void handle(NumberConsumer value) {
        try {
            value.accept(this.getNumber());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public NumberValue min(Number min) {
        double val = this.getAsDouble();
        if (val < min.doubleValue()) {
            throw new JParseException("Value at '" + this.path + "' must be " + String.valueOf(min) + " or bigger.");
        }
        return this;
    }

    @Override
    public NumberValue range(Number min, Number maxExclusive) {
        double val = this.getAsDouble();
        if (val < min.doubleValue() || val >= maxExclusive.doubleValue()) {
            throw new JParseException("Value at '" + this.path + "' must be between " + String.valueOf(min) + " and " + String.valueOf(maxExclusive) + " (exclusive).");
        }
        return this;
    }

    @Override
    public DoubleValue min(double min) {
        double val = this.getAsDouble();
        if (val < min) {
            throw new JParseException("Value at '" + this.path + "' must be " + min + " or bigger.");
        }
        return this;
    }

    @Override
    public DoubleValue range(double min, double maxExclusive) {
        double val = this.getAsDouble();
        if (val < min || val >= maxExclusive) {
            throw new JParseException("Value at '" + this.path + "' must be between " + min + " and " + maxExclusive + " (exclusive).");
        }
        return this;
    }

    @Override
    public Number getNumber() {
        return null;
    }

    @Override
    public double getAsDouble() {
        return this.data.getAsJsonPrimitive().getAsDouble();
    }

    @Override
    public void handle(IntConsumer value) {
        try {
            value.accept(this.getAsInt());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public IntValue min(int min) {
        int val = this.getAsInt();
        if (val < min) {
            throw new JParseException("Value at '" + this.path + "' must be " + min + " or bigger.");
        }
        return this;
    }

    @Override
    public IntValue range(int min, int maxExclusive) {
        int val = this.data.getAsJsonPrimitive().getAsInt();
        if (val < min || val >= maxExclusive) {
            throw new JParseException("Value at '" + this.path + "' must be between " + min + " and " + maxExclusive + " (exclusive).");
        }
        return this;
    }

    @Override
    public int getAsInt() {
        return this.data.getAsJsonPrimitive().getAsInt();
    }

    @Override
    public void handle(BooleanConsumer value) {
        try {
            value.accept(this.getAsBoolean());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public boolean getAsBoolean() {
        return this.data.getAsJsonPrimitive().getAsBoolean();
    }

    @Override
    public void handle(LongConsumer value) {
        try {
            value.accept(this.getAsLong());
        }
        catch (Exception e) {
            if (e instanceof JParseException) {
                throw e;
            }
            throw new JParseException("Error running handler for " + this.path, e);
        }
    }

    @Override
    public LongValue min(long min) {
        long val = this.getAsLong();
        if (val < min) {
            throw new JParseException("Value at '" + this.path + "' must be " + min + " or bigger.");
        }
        return this;
    }

    @Override
    public LongValue range(long min, long maxExclusive) {
        long val = this.getAsLong();
        if (val < min || val >= maxExclusive) {
            throw new JParseException("Value at '" + this.path + "' must be between " + min + " and " + maxExclusive + " (exclusive).");
        }
        return this;
    }

    @Override
    public long getAsLong() {
        return this.data.getAsJsonPrimitive().getAsLong();
    }
}

