/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.mojang.logging.LogUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RunnableQueue
implements Executor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Thread thread = Thread.currentThread();
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();

    public boolean isSameThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (!this.isSameThread()) {
            this.queue.add(command);
        } else {
            command.run();
        }
    }

    public boolean runQueue() {
        if (!this.isSameThread()) {
            throw new IllegalStateException("This method must be called in the main thread.");
        }
        if (this.queue.size() > 0) {
            LOGGER.debug("Running " + this.queue.size() + " tasks (give or take)");
        }
        int n = 0;
        while (this.queue.size() > 0) {
            Runnable run = this.queue.poll();
            if (run != null) {
                run.run();
            }
            ++n;
        }
        return n != 0;
    }

    public void finish() {
    }

    public void waitForTasks() throws InterruptedException {
        Thread.sleep(1L);
    }
}

