/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.blocks;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.builders.BlockBuilder;
import dev.gigaherz.jsonthings.things.events.FlexEventContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlexWallBlock
extends WallBlock
implements IFlexBlock {
    private final Map<FlexEventType, FlexEventHandler> eventHandlers;
    private final List<Property<?>> stateProperties;
    private DynamicShape generalShape;
    private DynamicShape collisionShape;
    private DynamicShape raytraceShape;
    private DynamicShape renderShape;

    public FlexWallBlock(BlockBehaviour.Properties properties, BlockBuilder builder) {
        this.stateProperties = builder.getProperties();
        super(properties);
        this.eventHandlers = Maps.newHashMap();
        this.initializeFlex(builder.getPropertyDefaultValues());
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (!propertyDefaultValues.isEmpty()) {
            BlockState def = (BlockState)this.getStateDefinition().any();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (BlockState)def.setValue(prop, value);
            }
            this.registerDefaultState(def);
        }
    }

    @Override
    public <T> void addEventHandler(FlexEventType<T> event, FlexEventHandler<T> eventHandler) {
        this.eventHandlers.put(event, eventHandler);
    }

    @Override
    public <T> FlexEventHandler<T> getEventHandler(FlexEventType<T> event) {
        return this.eventHandlers.get(event);
    }

    @Override
    public void setGeneralShape(@Nullable DynamicShape shape) {
        this.generalShape = shape;
    }

    @Override
    public void setCollisionShape(@Nullable DynamicShape shape) {
        this.collisionShape = shape;
    }

    @Override
    public void setRaytraceShape(@Nullable DynamicShape shape) {
        this.raytraceShape = shape;
    }

    @Override
    public void setRenderShape(@Nullable DynamicShape shape) {
        this.renderShape = shape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder1) {
        super.createBlockStateDefinition(builder1);
        StateDefinition.Builder<Block, BlockState> builder = builder1;
        Objects.requireNonNull(builder);
        StateDefinition.Builder<Block, BlockState> builder2 = builder;
        this.stateProperties.forEach(xva$0 -> builder2.add(new Property[]{xva$0}));
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (this.generalShape != null) {
            return this.generalShape.getShape(state);
        }
        return super.getShape(state, worldIn, pos, context);
    }

    @Deprecated
    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (this.raytraceShape != null) {
            return this.raytraceShape.getShape(state);
        }
        return super.getInteractionShape(state, worldIn, pos);
    }

    @Deprecated
    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        if (this.collisionShape != null) {
            return this.collisionShape.getShape(state);
        }
        return super.getBlockSupportShape(state, reader, pos);
    }

    @Deprecated
    public VoxelShape getOcclusionShape(BlockState state) {
        if (this.renderShape != null) {
            return this.renderShape.getShape(state);
        }
        return super.getOcclusionShape(state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return (InteractionResult)this.runEvent(FlexEventType.USE_BLOCK_WITHOUT_ITEM, FlexEventContext.of(level, pos, state).with(FlexEventContext.USER, player).withRayTrace(hitResult), () -> super.useWithoutItem(state, level, pos, player, hitResult));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return (InteractionResult)this.runEvent(FlexEventType.USE_BLOCK_WITH_ITEM, FlexEventContext.of(level, pos, state).with(FlexEventContext.USER, player).withRayTrace(hitResult), () -> super.useItemOn(stack, state, level, pos, player, hand, hitResult));
    }
}

