/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParseException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ConsumableBuilder
extends BaseBuilder<Consumable, ConsumableBuilder> {
    private float consumeSeconds;
    private ItemUseAnimation animation;
    private Identifier sound;
    private boolean hasConsumeParticles;
    private JsonElement[] onConsumeEffects;
    private DeferredHolder<SoundEvent, SoundEvent> soundEvent;

    public static ConsumableBuilder begin(ThingParser<Consumable, ConsumableBuilder> ownerParser, Identifier registryName) {
        return new ConsumableBuilder(ownerParser, registryName);
    }

    private ConsumableBuilder(ThingParser<Consumable, ConsumableBuilder> ownerParser, Identifier registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Consummable";
    }

    public void setConsumeSeconds(float consumeSeconds) {
        this.consumeSeconds = consumeSeconds;
    }

    public void setAnimation(ItemUseAnimation animation) {
        this.animation = animation;
    }

    public void setSound(Identifier sound) {
        this.sound = sound;
    }

    public void setHasConsumeParticles(boolean hasConsumeParticles) {
        this.hasConsumeParticles = hasConsumeParticles;
    }

    public void setOnConsumeEffects(JsonElement[] onConsumeEffects) {
        this.onConsumeEffects = onConsumeEffects;
    }

    @Override
    protected Consumable buildInternal() {
        this.soundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.sound);
        List<ConsumeEffect> consumeEffects = Arrays.stream(this.onConsumeEffects).map(e -> (ConsumeEffect)((Pair)ConsumeEffect.CODEC.decode((DynamicOps)JsonOps.INSTANCE, e).getOrThrow(JParseException::new)).getFirst()).toList();
        return new Consumable(this.consumeSeconds, this.animation, this.soundEvent, this.hasConsumeParticles, consumeEffects);
    }

    @Override
    public void validate() {
        if (this.soundEvent != null) {
            this.soundEvent.value();
        }
    }
}

