/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.registries.DeferredHolder;

public class SoundTypeBuilder
extends BaseBuilder<SoundType, SoundTypeBuilder> {
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private Identifier breakSound;
    private Identifier stepSound;
    private Identifier placeSound;
    private Identifier hitSound;
    private Identifier fallSound;
    private DeferredHolder<SoundEvent, SoundEvent> breakSoundEvent;
    private DeferredHolder<SoundEvent, SoundEvent> stepSoundEvent;
    private DeferredHolder<SoundEvent, SoundEvent> placeSoundEvent;
    private DeferredHolder<SoundEvent, SoundEvent> hitSoundEvent;
    private DeferredHolder<SoundEvent, SoundEvent> fallSoundEvent;

    public static SoundTypeBuilder begin(ThingParser<SoundType, SoundTypeBuilder> ownerParser, Identifier registryName) {
        return new SoundTypeBuilder(ownerParser, registryName);
    }

    private SoundTypeBuilder(ThingParser<SoundType, SoundTypeBuilder> ownerParser, Identifier registryName) {
        super(ownerParser, registryName);
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setBreakSound(Identifier resourceLocation) {
        this.breakSound = resourceLocation;
    }

    public void setStepSound(Identifier resourceLocation) {
        this.stepSound = resourceLocation;
    }

    public void setHitSound(Identifier resourceLocation) {
        this.hitSound = resourceLocation;
    }

    public void setFallSound(Identifier resourceLocation) {
        this.fallSound = resourceLocation;
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Sound Type";
    }

    @Override
    protected SoundType buildInternal() {
        this.breakSoundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.breakSound);
        this.stepSoundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.stepSound);
        this.placeSoundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.placeSound);
        this.hitSoundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.hitSound);
        this.fallSoundEvent = DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (Identifier)this.fallSound);
        return new DeferredSoundType(this.volume, this.pitch, this.breakSoundEvent, this.stepSoundEvent, this.placeSoundEvent, this.hitSoundEvent, this.fallSoundEvent);
    }

    @Override
    public void validate() {
        if (this.breakSoundEvent != null) {
            this.breakSoundEvent.value();
        }
        if (this.stepSoundEvent != null) {
            this.stepSoundEvent.value();
        }
        if (this.placeSoundEvent != null) {
            this.placeSoundEvent.value();
        }
        if (this.hitSoundEvent != null) {
            this.hitSoundEvent.value();
        }
        if (this.fallSoundEvent != null) {
            this.fallSoundEvent.value();
        }
    }
}

