/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.fluids;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import dev.gigaherz.jsonthings.things.events.FlexEventType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidType;

public class FlexFluid
extends Fluid
implements IFlexFluid {
    private final Map<FlexEventType, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private Supplier<Item> bucketItem = () -> Items.AIR;
    private Supplier<FluidType> fluidType;

    public FlexFluid(Supplier<FluidType> fluidType, Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        this.fluidType = fluidType;
        this.initializeFlex(propertyDefaultValues);
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (propertyDefaultValues.size() > 0) {
            FluidState def = (FluidState)this.getStateDefinition().any();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (FluidState)def.setValue(prop, value);
            }
            this.registerDefaultState(def);
        }
    }

    @Override
    public <T> void addEventHandler(FlexEventType<T> event, FlexEventHandler<T> eventHandler) {
        this.eventHandlers.put(event, eventHandler);
    }

    @Override
    public <T> FlexEventHandler<T> getEventHandler(FlexEventType<T> event) {
        return this.eventHandlers.get(event);
    }

    @Override
    public void setBucketItem(Supplier<Item> bucketItem) {
        this.bucketItem = bucketItem;
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }

    public Item getBucket() {
        return this.bucketItem != null ? this.bucketItem.get() : Items.AIR;
    }

    protected boolean canBeReplacedWith(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
        return true;
    }

    public Vec3 getFlow(BlockGetter pBlockReader, BlockPos pPos, FluidState pFluidState) {
        return Vec3.ZERO;
    }

    public int getTickDelay(LevelReader level) {
        return 0;
    }

    protected float getExplosionResistance() {
        return 0.0f;
    }

    public float getHeight(FluidState pState, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public float getOwnHeight(FluidState pState) {
        return 0.0f;
    }

    protected BlockState createLegacyBlock(FluidState pState) {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSource(FluidState pState) {
        return true;
    }

    public int getAmount(FluidState pState) {
        return 0;
    }

    public VoxelShape getShape(FluidState pState, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }
}

