/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.SoundTypeBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.SoundType;

public class SoundTypeParser
extends ThingParser<SoundType, SoundTypeBuilder> {
    public SoundTypeParser() {
        super(GSON, "sound_type");
    }

    @Override
    protected void finishLoadingInternal() {
        SoundTypeParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.register(ThingRegistries.SOUND_TYPE, (Identifier)thing.getRegistryName(), (Object)((SoundType)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public SoundTypeBuilder processThing(Identifier key, JsonObject data, Consumer<SoundTypeBuilder> builderModification) {
        SoundTypeBuilder builder = SoundTypeBuilder.begin(this, key);
        JParse.begin(data).ifKey("volume", val -> val.floatValue().range(0.0f, 1.0f).handle(builder::setVolume)).ifKey("pitch", val -> val.floatValue().min(0.0f).handle(builder::setPitch)).key("break_sound", val -> val.string().map(Identifier::parse).handle(builder::setBreakSound)).key("step_sound", val -> val.string().map(Identifier::parse).handle(builder::setStepSound)).key("hit_sound", val -> val.string().map(Identifier::parse).handle(builder::setHitSound)).key("fall_sound", val -> val.string().map(Identifier::parse).handle(builder::setFallSound));
        builderModification.accept(builder);
        return builder;
    }
}

