/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting;

import dev.gigaherz.jsonthings.things.parsers.ThingResourceManager;
import dev.gigaherz.jsonthings.things.scripting.ThingScript;
import dev.gigaherz.jsonthings.things.scripting.rhino.RhinoThingScript;
import dev.gigaherz.jsonthings.util.KeyNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptParser
extends SimplePreparableReloadListener<Map<Identifier, ThingScript>> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ScriptParser instance = new ScriptParser();
    public static final String SCRIPTS_FOLDER = "scripts";
    public static final int SCRIPTS_FOLDER_LENGTH = "scripts".length();
    public static final String JS_EXTENSION = ".js";
    public static final int JS_EXTENSION_LENGTH = ".js".length();
    private static boolean enabled = false;
    private Map<Identifier, ThingScript> scripts = new HashMap<Identifier, ThingScript>();

    public static ScriptParser instance() {
        return instance;
    }

    public static void enable(ThingResourceManager manager) {
        if (!enabled) {
            manager.addResourceReloadListener((PreparableReloadListener)ScriptParser.instance());
            enabled = true;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    protected Map<Identifier, ThingScript> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Map resources = pResourceManager.listResources(SCRIPTS_FOLDER, t -> t.getPath().endsWith(JS_EXTENSION));
        HashMap<Identifier, ThingScript> map = new HashMap<Identifier, ThingScript>();
        for (Map.Entry entry : resources.entrySet()) {
            Identifier key = (Identifier)entry.getKey();
            Resource res = (Resource)entry.getValue();
            String path = key.getPath();
            String cleanPath = path.substring(SCRIPTS_FOLDER_LENGTH + 1, path.length() - JS_EXTENSION_LENGTH);
            Identifier id = Identifier.fromNamespaceAndPath((String)key.getNamespace(), (String)cleanPath);
            try {
                map.put(id, RhinoThingScript.fromResource(res, id.toString()));
            }
            catch (IOException | ScriptException e) {
                LOGGER.error("Error parsing script " + String.valueOf(res), (Throwable)e);
            }
        }
        return map;
    }

    protected void apply(Map<Identifier, ThingScript> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.scripts = pObject;
    }

    @Nonnull
    public ThingScript getEvent(Identifier id) {
        if (!this.scripts.containsKey(id)) {
            throw new KeyNotFoundException("Script with id " + String.valueOf(id) + " not found.");
        }
        return this.scripts.get(id);
    }
}

