/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino.dsl;

import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.DSLHelpers;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.LambdaBaseFunction;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.NativeObject;
import dev.gigaherz.rhinolib.Scriptable;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlocksDSL {
    public static void use(Context cx, Scriptable scope) {
        if (scope.has(cx, ".use_blocks", scope)) {
            return;
        }
        scope.put(cx, "block", scope, (Object)new LambdaBaseFunction(BlocksDSL::findBlock));
        scope.put(cx, "blockState", scope, (Object)new LambdaBaseFunction(BlocksDSL::makeBlockState));
        scope.put(cx, ".use_blocks", scope, (Object)true);
    }

    private static Object findBlock(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Block block = (Block)DSLHelpers.find(BuiltInRegistries.BLOCK, (String)args[0]);
        return DSLHelpers.wrap(cx, scope, block, Block.class);
    }

    private static Object makeBlockState(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Block block = (Block)DSLHelpers.getRegistryEntry(args[0], BuiltInRegistries.BLOCK);
        BlockState baseState = block.defaultBlockState();
        if (args.length > 1) {
            NativeObject obj = (NativeObject)args[1];
            Collection props = baseState.getProperties();
            for (Map.Entry kv : obj.entrySet()) {
                String key = (String)kv.getKey();
                Object value = kv.getValue();
                if (value instanceof NativeJavaObject) {
                    NativeJavaObject wrapped = (NativeJavaObject)value;
                    value = wrapped.unwrap();
                }
                Property prop = props.stream().filter(p -> p.getName().equals(key)).findFirst().orElseThrow();
                baseState = (BlockState)baseState.setValue(prop, (Comparable)value);
            }
        }
        return DSLHelpers.wrap(cx, scope, baseState, BlockState.class);
    }
}

