/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino.dsl;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.rhinolib.ConsString;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.NativeJSON;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.NativeObject;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class DSLHelpers {
    private static Logger LOGGER = LogUtils.getLogger();

    public static <T> T find(Registry<T> reg, String n) {
        Identifier rl = Identifier.parse((String)n);
        if (!reg.containsKey(rl)) {
            throw new RuntimeException("Cannot find element with name " + String.valueOf(rl));
        }
        return reg.getOptional(rl).orElseThrow();
    }

    public static <T> Holder<T> findHolder(Registry<T> reg, String n) {
        Identifier rl = Identifier.parse((String)n);
        if (!reg.containsKey(rl)) {
            throw new RuntimeException("Cannot find element with name " + String.valueOf(rl));
        }
        return (Holder)reg.get(rl).orElseThrow();
    }

    public static <T> T getRegistryEntry(Object arg, Registry<T> reg) {
        T t;
        if (arg instanceof String) {
            String str = (String)arg;
            t = DSLHelpers.find(reg, str);
        } else {
            t = DSLHelpers.get(arg);
        }
        return t;
    }

    public static <T> Holder<T> getRegistryHolder(Object arg, Registry<T> reg) {
        Holder<T> holder;
        if (arg instanceof String) {
            String str = (String)arg;
            holder = DSLHelpers.findHolder(reg, str);
        } else {
            holder = (Holder<T>)DSLHelpers.get(arg);
        }
        return holder;
    }

    public static <T> T get(Object arg) {
        return (T)((NativeJavaObject)arg).unwrap();
    }

    public static <T> T get(Object arg, Class<T> target) {
        return target.cast(((NativeJavaObject)arg).unwrap());
    }

    public static byte getByte(Object arg) {
        return ((Number)arg).byteValue();
    }

    public static short getShort(Object arg) {
        return ((Number)arg).shortValue();
    }

    public static int getInt(Object arg) {
        return ((Number)arg).intValue();
    }

    public static long getLong(Object arg) {
        return ((Number)arg).longValue();
    }

    public static float getFloat(Object arg) {
        return ((Number)arg).floatValue();
    }

    public static double getDouble(Object arg) {
        return ((Number)arg).doubleValue();
    }

    public static String getString(Object arg) {
        return (String)arg;
    }

    public static Component getComponent(Context cx, Object arg) {
        if (arg instanceof NativeJavaObject) {
            NativeJavaObject o = (NativeJavaObject)arg;
            arg = o.unwrap();
        }
        if (arg instanceof String) {
            String s = (String)arg;
            return Component.literal((String)s);
        }
        if (arg instanceof ConsString) {
            ConsString cs = (ConsString)arg;
            return Component.literal((String)cs.toString());
        }
        if (arg instanceof NativeObject) {
            NativeObject obj = (NativeObject)arg;
            RegistryAccess.Frozen provider = RegistryAccess.EMPTY;
            return (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider), (Object)JsonParser.parseString((String)NativeJSON.stringify((Object)obj, null, (Object)0, (Context)cx))).getOrThrow()).getFirst();
        }
        return Component.literal((String)"unknown");
    }

    public static Object wrap(Context cx, Scriptable scope, Object arg) {
        return DSLHelpers.wrap(cx, scope, arg, null);
    }

    public static <T> Object wrap(Context cx, Scriptable scope, @Nullable T value, @Nullable Class<? super T> fieldType) {
        scope = ScriptableObject.getTopLevelScope((Scriptable)scope);
        return cx.getWrapFactory().wrap(cx, scope, value, fieldType);
    }

    public static void debugDumpBindings() {
        DSLHelpers.debugDumpBindings(Item.class);
        DSLHelpers.debugDumpBindings(Items.class);
        DSLHelpers.debugDumpBindings(ItemStack.class);
        DSLHelpers.debugDumpBindings(Block.class);
        DSLHelpers.debugDumpBindings(Blocks.class);
        DSLHelpers.debugDumpBindings(BlockState.class);
        DSLHelpers.debugDumpBindings(Enchantment.class);
        DSLHelpers.debugDumpBindings(Enchantments.class);
        DSLHelpers.debugDumpBindings(EnchantmentHelper.class);
        DSLHelpers.debugDumpBindings(MobEffect.class);
        DSLHelpers.debugDumpBindings(MobEffects.class);
        DSLHelpers.debugDumpBindings(MobEffectInstance.class);
        DSLHelpers.debugDumpBindings(Level.class);
        DSLHelpers.debugDumpBindings(Tag.class);
        DSLHelpers.debugDumpBindings(ByteTag.class);
        DSLHelpers.debugDumpBindings(ShortTag.class);
        DSLHelpers.debugDumpBindings(IntTag.class);
        DSLHelpers.debugDumpBindings(LongTag.class);
        DSLHelpers.debugDumpBindings(FloatTag.class);
        DSLHelpers.debugDumpBindings(DoubleTag.class);
        DSLHelpers.debugDumpBindings(StringTag.class);
        DSLHelpers.debugDumpBindings(ListTag.class);
        DSLHelpers.debugDumpBindings(CompoundTag.class);
        DSLHelpers.debugDumpBindings(ByteArrayTag.class);
        DSLHelpers.debugDumpBindings(IntArrayTag.class);
        DSLHelpers.debugDumpBindings(LongArrayTag.class);
    }

    public static void debugDumpBindings(Class<?> cls) {
        boolean isStatic;
        int mod;
        LOGGER.info("Dumping class bindings for " + cls.getCanonicalName());
        LOGGER.info("Static wrapper: ");
        for (Method method : cls.getDeclaredMethods()) {
            mod = method.getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || !isStatic) continue;
            LOGGER.info("m {}", (Object)method.getName());
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            mod = ((Field)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || !isStatic) continue;
            LOGGER.info("f {}", (Object)((Field)accessibleObject).getName());
        }
        LOGGER.info("Instance wrapper: ");
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            mod = ((Method)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || isStatic) continue;
            LOGGER.info("m {}", (Object)((Method)accessibleObject).getName());
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            mod = ((Field)accessibleObject).getModifiers();
            isStatic = Modifier.isStatic(mod);
            if (!Modifier.isPublic(mod) || isStatic) continue;
            LOGGER.info("f {}", (Object)((Field)accessibleObject).getName());
        }
    }
}

