/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.blocks.FlexBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFallingBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceGateBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexHorizontalDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLeavesBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLiquidBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexRotatedPillarBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSaplingBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSlabBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexStairsBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexTrapdoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexWallBlock;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.serializers.IBlockFactory;
import dev.gigaherz.jsonthings.things.serializers.IBlockSerializer;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexBlockType<T extends Block> {
    public static final FlexBlockType<FlexBlock> PLAIN = FlexBlockType.register("plain", jsonObject -> FlexBlock::new, DefaultTypeProperties.builder());
    public static final FlexBlockType<FlexFallingBlock> FALLING = FlexBlockType.register("falling", data -> {
        MutableObject dustColor = new MutableObject((Object)new ColorRGBA(-1));
        JParse.begin(data).ifKey("dust_color", val -> val.ifInteger(num -> num.handle(color -> dustColor.setValue((Object)new ColorRGBA(color)))).ifObj(num -> num.map(obj -> {
            int r = GsonHelper.getAsInt((JsonObject)obj, (String)"r");
            int g = GsonHelper.getAsInt((JsonObject)obj, (String)"g");
            int b = GsonHelper.getAsInt((JsonObject)obj, (String)"b");
            int a = GsonHelper.getAsInt((JsonObject)obj, (String)"a", (int)255);
            return new ColorRGBA(ARGB.color((int)a, (int)r, (int)g, (int)b));
        }).handle(arg_0 -> ((MutableObject)dustColor).setValue(arg_0))).typeError());
        ColorRGBA color = (ColorRGBA)dustColor.get();
        return (props, builder) -> new FlexFallingBlock(props, builder, color);
    }, DefaultTypeProperties.builder().defaultLayer("cutout"));
    public static final FlexBlockType<FlexSaplingBlock> SAPLING = FlexBlockType.register("sapling", data -> (props, builder) -> {
        Identifier featureId = Identifier.parse((String)GsonHelper.getAsString((JsonObject)data, (String)"tree_feature"));
        ResourceKey featureKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (Identifier)featureId);
        TreeGrower treeGrower = new TreeGrower(builder.getRegistryName().toString(), Optional.empty(), Optional.of(featureKey), Optional.empty());
        return new FlexSaplingBlock(props, builder, treeGrower);
    }, DefaultTypeProperties.builder().defaultLayer("cutout").defaultTicksRandomly(true));
    public static final FlexBlockType<FlexDirectionalBlock> DIRECTIONAL = FlexBlockType.register("directional", jsonObject -> FlexDirectionalBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{DirectionalBlock.FACING}));
    public static final FlexBlockType<FlexHorizontalDirectionalBlock> HORIZONTAL_DIRECTIONAL = FlexBlockType.register("horizontal_directional", jsonObject -> FlexHorizontalDirectionalBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{HorizontalDirectionalBlock.FACING}));
    public static final FlexBlockType<FlexRotatedPillarBlock> ROTATED_PILLAR = FlexBlockType.register("rotated_pillar", jsonObject -> FlexRotatedPillarBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{RotatedPillarBlock.AXIS}));
    public static final FlexBlockType<FlexSlabBlock> SLAB = FlexBlockType.register("slab", jsonObject -> FlexSlabBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{SlabBlock.TYPE, SlabBlock.WATERLOGGED}));
    public static final FlexBlockType<FlexStairsBlock> STAIRS = FlexBlockType.register("stairs", jsonObject -> FlexStairsBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{StairBlock.FACING, StairBlock.HALF, StairBlock.SHAPE, StairBlock.WATERLOGGED}));
    public static final FlexBlockType<FlexWallBlock> WALL = FlexBlockType.register("wall", jsonObject -> FlexWallBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{WallBlock.UP, WallBlock.EAST, WallBlock.NORTH, WallBlock.SOUTH, WallBlock.WEST, WallBlock.WATERLOGGED}));
    public static final FlexBlockType<FlexFenceBlock> FENCE = FlexBlockType.register("fence", jsonObject -> FlexFenceBlock::new, DefaultTypeProperties.builder().stockProperties(new Property[]{FenceBlock.NORTH, FenceBlock.EAST, FenceBlock.SOUTH, FenceBlock.WEST, FenceBlock.WATERLOGGED}));
    public static final FlexBlockType<FlexFenceGateBlock> FENCE_GATE = FlexBlockType.register("fence_gate", data -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("wood_type", any -> any.string().map(Identifier::parse).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        String woodTypeName = ((Identifier)blockSetType.get()).toString();
        return (props, builder) -> {
            WoodType woodType = WoodType.values().filter(w -> Objects.equals(w.name(), woodTypeName)).findFirst().orElseThrow();
            return new FlexFenceGateBlock(props, builder, woodType);
        };
    }, DefaultTypeProperties.builder().stockProperties(new Property[]{FenceGateBlock.OPEN, FenceGateBlock.POWERED, FenceGateBlock.IN_WALL}));
    public static final FlexBlockType<FlexLeavesBlock> LEAVES = FlexBlockType.register("leaves", data -> {
        MutableFloat leafChance = new MutableFloat(0.0f);
        JParse.begin(data).ifKey("leaf_chance", any -> any.floatValue().handle(arg_0 -> ((MutableFloat)leafChance).setValue(arg_0)));
        return (props, builder) -> new FlexLeavesBlock(props, builder, leafChance.floatValue());
    }, DefaultTypeProperties.builder().defaultLayer("cutout_mipped").defaultSeeThrough(true).stockProperties(new Property[]{LeavesBlock.DISTANCE, LeavesBlock.PERSISTENT}));
    public static final FlexBlockType<FlexDoorBlock> DOOR = FlexBlockType.register("door", data -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("block_set_type", any -> any.string().map(Identifier::parse).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        String woodTypeName = ((Identifier)blockSetType.get()).toString();
        return (props, builder) -> {
            BlockSetType woodType = BlockSetType.values().filter(w -> Objects.equals(w.name(), woodTypeName)).findFirst().orElseThrow(() -> new ThingParseException("Block set type not found: " + woodTypeName));
            return new FlexDoorBlock(props, builder, woodType);
        };
    }, DefaultTypeProperties.builder().defaultLayer("cutout").defaultSeeThrough(true).stockProperties(new Property[]{DoorBlock.FACING, DoorBlock.OPEN, DoorBlock.HINGE, DoorBlock.POWERED, DoorBlock.HALF}));
    public static final FlexBlockType<FlexTrapdoorBlock> TRAPDOOR = FlexBlockType.register("trapdoor", data -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("block_set_type", any -> any.string().map(Identifier::parse).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        String woodTypeName = ((Identifier)blockSetType.get()).toString();
        return (props, builder) -> {
            BlockSetType woodType = BlockSetType.values().filter(w -> Objects.equals(w.name(), woodTypeName)).findFirst().orElseThrow();
            return new FlexTrapdoorBlock(props, builder, woodType);
        };
    }, DefaultTypeProperties.builder().defaultLayer("cutout").defaultSeeThrough(true).stockProperties(new Property[]{TrapDoorBlock.OPEN, TrapDoorBlock.HALF, TrapDoorBlock.POWERED, TrapDoorBlock.WATERLOGGED}));
    public static final FlexBlockType<FlexLiquidBlock> LIQUID = FlexBlockType.register("liquid", data -> {
        ObjValue extras = JParse.begin(data);
        MutableObject fluid = new MutableObject();
        extras.key("fluid", any -> any.string().map(Identifier::parse).handle(arg_0 -> ((MutableObject)fluid).setValue(arg_0)));
        return (props, builder) -> {
            Identifier fluidName = fluid.get() != null ? (Identifier)fluid.get() : builder.getRegistryName();
            Fluid fluidObj = (Fluid)Utils.getOrCrash(BuiltInRegistries.FLUID, fluidName);
            if (!(fluidObj instanceof FlowingFluid)) {
                throw new RuntimeException("LiquidBlock requires a flowing fluid");
            }
            FlowingFluid flowingFluid = (FlowingFluid)fluidObj;
            return new FlexLiquidBlock(props.liquid(), builder, flowingFluid);
        };
    }, DefaultTypeProperties.builder().defaultLayer("translucent").defaultSeeThrough(true).stockProperties(new Property[]{LiquidBlock.LEVEL}));
    private final IBlockSerializer<T> factory;
    private final DefaultTypeProperties defaults;

    public static void init() {
    }

    public static <T extends Block> FlexBlockType<T> register(String name, IBlockSerializer<T> factory, DefaultTypeProperties defaults) {
        return (FlexBlockType)Registry.register(ThingRegistries.BLOCK_TYPE, (String)name, new FlexBlockType<T>(factory, defaults));
    }

    private FlexBlockType(IBlockSerializer<T> factory, DefaultTypeProperties defaults) {
        this.factory = factory;
        this.defaults = defaults;
    }

    public IBlockFactory<T> getFactory(JsonObject data) {
        return this.factory.createFactory(data);
    }

    public DefaultTypeProperties getDefaults() {
        return this.defaults;
    }

    public String toString() {
        return "BlockType{" + String.valueOf(ThingRegistries.BLOCK_TYPE.getKey((Object)this)) + "}";
    }

    public static final class DefaultTypeProperties {
        private String defaultLayer = "solid";
        private boolean defaultSeeThrough = false;
        private boolean defaultIgnitedByLava = false;
        private boolean defaultReplaceable = false;
        private boolean defaultTicksRandomly = false;
        private Property<?>[] stockProperties;

        public static DefaultTypeProperties builder() {
            return new DefaultTypeProperties();
        }

        private DefaultTypeProperties() {
        }

        public List<Property<?>> getStockProperties() {
            return this.stockProperties != null ? Arrays.asList(this.stockProperties) : Collections.emptyList();
        }

        public String getDefaultLayer() {
            return this.defaultLayer;
        }

        public boolean isDefaultSeeThrough() {
            return this.defaultSeeThrough;
        }

        public boolean isDefaultIgnitedByLava() {
            return this.defaultIgnitedByLava;
        }

        public boolean isDefaultReplaceable() {
            return this.defaultReplaceable;
        }

        public boolean isDefaultTicksRandomly() {
            return this.defaultTicksRandomly;
        }

        public DefaultTypeProperties defaultLayer(String defaultLayer) {
            this.defaultLayer = defaultLayer;
            return this;
        }

        public DefaultTypeProperties defaultSeeThrough(boolean defaultSeeThrough) {
            this.defaultSeeThrough = defaultSeeThrough;
            return this;
        }

        public DefaultTypeProperties defaultIgnitedByLava(boolean defaultIgnitedByLava) {
            this.defaultIgnitedByLava = defaultIgnitedByLava;
            return this;
        }

        public DefaultTypeProperties defaultReplaceable(boolean defaultReplaceable) {
            this.defaultReplaceable = defaultReplaceable;
            return this;
        }

        public DefaultTypeProperties defaultTicksRandomly(boolean defaultTicksRandomly) {
            this.defaultTicksRandomly = defaultTicksRandomly;
            return this;
        }

        public DefaultTypeProperties stockProperties(Property<?> ... stockProperties) {
            this.stockProperties = stockProperties;
            return this;
        }
    }
}

