/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.items.FlexAxeItem;
import dev.gigaherz.jsonthings.things.items.FlexBlockItem;
import dev.gigaherz.jsonthings.things.items.FlexBucketItem;
import dev.gigaherz.jsonthings.things.items.FlexDrinkableBottleItem;
import dev.gigaherz.jsonthings.things.items.FlexHoeItem;
import dev.gigaherz.jsonthings.things.items.FlexItem;
import dev.gigaherz.jsonthings.things.items.FlexShovelItem;
import dev.gigaherz.jsonthings.things.serializers.IItemFactory;
import dev.gigaherz.jsonthings.things.serializers.IItemSerializer;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Supplier;
import joptsimple.internal.Strings;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexItemType<T extends Item> {
    public static final FlexItemType<FlexItem> PLAIN = FlexItemType.register("plain", data -> FlexItem::new);
    public static final FlexItemType<FlexBlockItem> BLOCK = FlexItemType.register("block", data -> {
        String name = GsonHelper.getAsString((JsonObject)data, (String)"places", null);
        boolean useBlockName = GsonHelper.getAsBoolean((JsonObject)data, (String)"use_block_name", (boolean)true);
        return (props, builder) -> {
            Identifier blockName = name != null ? Identifier.parse((String)name) : builder.getRegistryName();
            Block block = (Block)Utils.getOrCrash(BuiltInRegistries.BLOCK, blockName);
            if (useBlockName) {
                props.useBlockDescriptionPrefix();
            }
            return new FlexBlockItem(block, props, builder);
        };
    });
    public static final FlexItemType<FlexDrinkableBottleItem> DRINKABLE_BOTTLE = FlexItemType.register("drinkable_bottle", data -> {
        MutableObject baseItemName = new MutableObject();
        JParse.begin(data).ifKey("base_item", val -> val.string().map(Identifier::parse).handle(arg_0 -> ((MutableObject)baseItemName).setValue(arg_0)));
        return (props, builder) -> {
            DeferredHolder baseItem = baseItemName.getValue() != null ? DeferredHolder.create((ResourceKey)Registries.ITEM, (Identifier)((Identifier)baseItemName.getValue())) : () -> Items.GLASS_BOTTLE;
            return new FlexDrinkableBottleItem((Supplier<Item>)baseItem, props, builder);
        };
    });
    public static final FlexItemType<FlexBucketItem> BUCKET = FlexItemType.register("bucket", data -> {
        String name = GsonHelper.getAsString((JsonObject)data, (String)"fluid", null);
        return (props, builder) -> {
            Identifier fluidName;
            if (name != null) {
                fluidName = Identifier.parse((String)name);
            } else {
                Identifier thisName = builder.getRegistryName();
                String path = thisName.getPath();
                if (path.endsWith("_bucket")) {
                    path = path.substring(0, path.length() - "_bucket".length());
                }
                fluidName = Identifier.fromNamespaceAndPath((String)thisName.getNamespace(), (String)path);
            }
            return new FlexBucketItem((Supplier<Fluid>)Lazy.of(() -> (Fluid)Utils.getOrCrash(BuiltInRegistries.FLUID, fluidName)), props, builder);
        };
    });
    public static final FlexItemType<FlexShovelItem> SHOVEL = FlexItemType.register("shovel", FlexItemType.makeToolSerializer(FlexShovelItem::new));
    public static final FlexItemType<FlexAxeItem> AXE = FlexItemType.register("axe", FlexItemType.makeToolSerializer(FlexAxeItem::new));
    public static final FlexItemType<FlexHoeItem> HOE = FlexItemType.register("hoe", FlexItemType.makeToolSerializer(FlexHoeItem::new));
    private final IItemSerializer<T> factory;

    private static <T extends Item> IItemSerializer<T> makeToolSerializer(DiggerFactory<T> factory) {
        return data -> {
            String tier = FlexItemType.parseTier(data);
            float damage = GsonHelper.getAsFloat((JsonObject)data, (String)"damage");
            float speed = GsonHelper.getAsFloat((JsonObject)data, (String)"speed");
            return (props, builder) -> {
                ToolMaterial tier_ = FlexItemType.getTier(tier);
                return factory.create(FlexItemType.getTier(tier), damage, speed, props, builder);
            };
        };
    }

    private static ToolMaterial getTier(String tierName) {
        return Utils.getOrCrash(ThingRegistries.TOOL_MATERIAL, Identifier.parse((String)tierName));
    }

    private static String parseTier(JsonObject data) {
        String str;
        if (data.has("tier")) {
            str = data.get("tier").getAsString();
            if (Strings.isNullOrEmpty((String)str)) {
                throw new RuntimeException("Tool tier must be a non-empty string.");
            }
        } else {
            throw new RuntimeException("Tool info must have a non-empty 'tier' string.");
        }
        String tierName = str;
        return tierName;
    }

    public static void init() {
    }

    public static <T extends Item> FlexItemType<T> register(String name, IItemSerializer<T> factory) {
        return (FlexItemType)Registry.register(ThingRegistries.ITEM_TYPE, (String)name, new FlexItemType<T>(factory));
    }

    private FlexItemType(IItemSerializer<T> factory) {
        this.factory = factory;
    }

    public IItemFactory<T> getFactory(JsonObject data) {
        return this.factory.createFactory(data);
    }

    public String toString() {
        return "ItemType{" + String.valueOf(ThingRegistries.ITEM_TYPE.getKey((Object)this)) + "}";
    }

    @FunctionalInterface
    public static interface DiggerFactory<T extends Item> {
        public T create(ToolMaterial var1, float var2, float var3, Item.Properties var4, ItemBuilder var5);
    }
}

