/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.shapes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.shapes.BasicShape;
import dev.gigaherz.jsonthings.things.shapes.CombinedShape;
import dev.gigaherz.jsonthings.things.shapes.ConditionalShape;
import dev.gigaherz.jsonthings.things.shapes.IShapeProvider;
import dev.gigaherz.jsonthings.util.CodecExtras;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DynamicShape {
    private static final Codec<IShapeProvider> SHAPE_CODEC = CodecExtras.makeChoiceCodec(CodecExtras.toSubclass(ConditionalShape.CODEC, ConditionalShape.class), CodecExtras.toSubclass(CombinedShape.CODEC, CombinedShape.class), CodecExtras.toSubclass(BasicShape.CODEC, BasicShape.class));
    public static final Codec<DynamicShape> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SHAPE_CODEC.fieldOf("shape").forGetter(shape -> shape.shape), (App)CodecExtras.PROPERTY_CODEC.optionalFieldOf("shape_rotation").forGetter(shape -> Optional.ofNullable(shape.facing))).apply((Applicative)instance, (shape, facing) -> new DynamicShape((IShapeProvider)shape, (Property<Direction>)((Property)facing.orElse(null)))));
    private static final DynamicShape EMPTY = new DynamicShape(new CombinedShape(BooleanOp.OR, Collections.emptyList()), null);
    private final Map<BlockState, VoxelShape> shapeCache = new IdentityHashMap<BlockState, VoxelShape>();
    private final IShapeProvider shape;
    @Nullable
    private final Property<Direction> facing;

    public static DynamicShape empty() {
        return EMPTY;
    }

    public static Codec<IShapeProvider> shapeCodec() {
        return SHAPE_CODEC;
    }

    public static DynamicShape parseShape(JsonElement element, @Nullable Property<Direction> facingProperty, Map<String, Property<?>> propertiesByName) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            String name = element.getAsString();
            return (DynamicShape)ThingRegistries.DYNAMIC_SHAPE.getOptional(Identifier.parse((String)name)).orElseThrow(() -> new IllegalStateException("No shape known with name " + name));
        }
        return DynamicShape.fromJson(element, facingProperty, propertiesByName::get);
    }

    public DynamicShape(IShapeProvider shape, @Nullable Property<Direction> facing) {
        this.shape = shape;
        this.facing = facing;
    }

    public VoxelShape getShape(BlockState blockstate) {
        return this.shapeCache.computeIfAbsent(blockstate, state -> {
            Direction d = this.facing != null ? (Direction)state.getValue(this.facing) : Direction.NORTH;
            return this.shape.getShape((BlockState)state, d).orElseGet(Shapes::block);
        });
    }

    public static DynamicShape fromJson(JsonElement data, @Nullable Property<Direction> facingProperty, Function<String, Property<?>> properties) {
        IShapeProvider shape = (IShapeProvider)((Pair)SHAPE_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow()).getFirst();
        shape = shape.bake(properties);
        return new DynamicShape(shape, facingProperty);
    }

    public static VoxelShape cuboidWithRotation(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case SOUTH: {
                return Shapes.box((double)(1.0 - x2), (double)y1, (double)(1.0 - z2), (double)(1.0 - x1), (double)y2, (double)(1.0 - z1));
            }
            case WEST: {
                return Shapes.box((double)z1, (double)y1, (double)(1.0 - x2), (double)z2, (double)y2, (double)(1.0 - x1));
            }
            case EAST: {
                return Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2);
            }
            case UP: {
                return Shapes.box((double)(1.0 - y1), (double)x1, (double)z1, (double)(1.0 - y2), (double)x2, (double)z2);
            }
            case DOWN: {
                return Shapes.box((double)y1, (double)(1.0 - x1), (double)z1, (double)y2, (double)(1.0 - x2), (double)z2);
            }
        }
        return Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }
}

