/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;

public class CustomPackType {
    public static final PackFormat PACK_FORMAT_VERSION = new PackFormat(11, 0);
    public static final PackType THINGS = Enum.valueOf(PackType.class, "JSONTHINGS_THINGS");
    public static final MetadataSectionType<PackMetadataSection> THINGS_METADATA = new MetadataSectionType("pack", CustomPackType.codecForPackType());
    public static final MetadataSectionType<PackMetadataSection> OPTIONAL_THINGS_METADATA = new MetadataSectionType("pack", CustomPackType.metadataCodecForPackType());
    public static final MetadataSectionType<OverlayMetadataSection> THINGS_OVERLAY = new MetadataSectionType("jsonthings:overlays", OverlayMetadataSection.codecForPackType((PackType)PackType.SERVER_DATA));
    private static final InclusiveRange<PackFormat> UNLIMITED_SUPPORT = new InclusiveRange((Comparable)new PackFormat(0, 0), (Comparable)new PackFormat(Integer.MAX_VALUE, Integer.MAX_VALUE));

    private static Codec<PackMetadataSection> codecForPackType() {
        return RecordCodecBuilder.create(p_432485_ -> p_432485_.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(PackMetadataSection::description), (App)PackFormat.packCodec((PackType)THINGS).forGetter(PackMetadataSection::supportedFormats)).apply((Applicative)p_432485_, PackMetadataSection::new));
    }

    private static Codec<PackMetadataSection> metadataCodecForPackType() {
        int lastPreMinor = PACK_FORMAT_VERSION.major();
        MapCodec formatCodec = PackFormat.IntermediaryFormat.PACK_CODEC.flatXmap(intermediary -> {
            if (intermediary.min().isEmpty() && intermediary.max().isEmpty() && intermediary.format().isEmpty() && intermediary.supported().isEmpty()) {
                return DataResult.success(UNLIMITED_SUPPORT);
            }
            return intermediary.validate(lastPreMinor, true, false, "Pack", "supported_formats");
        }, range -> {
            if (range.equals(UNLIMITED_SUPPORT)) {
                return DataResult.success((Object)new PackFormat.IntermediaryFormat(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
            }
            return DataResult.success((Object)PackFormat.IntermediaryFormat.fromRange((InclusiveRange)range, (int)lastPreMinor));
        });
        return RecordCodecBuilder.create(in -> in.group((App)ComponentSerialization.CODEC.optionalFieldOf("description", (Object)Component.empty()).forGetter(PackMetadataSection::description), (App)formatCodec.forGetter(PackMetadataSection::supportedFormats)).apply((Applicative)in, PackMetadataSection::new));
    }
}

