/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util.parse.value;

import com.google.gson.JsonArray;
import dev.gigaherz.jsonthings.util.parse.function.ArrayValueFunction;
import dev.gigaherz.jsonthings.util.parse.function.IntObjBiConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonArrayConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonArrayFunction;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.BooleanValue;
import dev.gigaherz.jsonthings.util.parse.value.DoubleValue;
import dev.gigaherz.jsonthings.util.parse.value.FloatValue;
import dev.gigaherz.jsonthings.util.parse.value.IntValue;
import dev.gigaherz.jsonthings.util.parse.value.LongValue;
import dev.gigaherz.jsonthings.util.parse.value.MappedArrayValue;
import dev.gigaherz.jsonthings.util.parse.value.MappedValue;
import dev.gigaherz.jsonthings.util.parse.value.StringValue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public interface ArrayValue {
    public void forEach(IntObjBiConsumer<Any> var1);

    public void collect(Consumer<Stream<Any>> var1);

    public <T> MappedArrayValue<T> map(Function<Any, T> var1);

    public <T> T flatMap(Function<Stream<Any>, T> var1);

    public <T> MappedValue<T[]> flatten(Function<Any, T> var1, IntFunction<T[]> var2);

    public ArrayValue notEmpty();

    public ArrayValue atLeast(int var1);

    public ArrayValue between(int var1, int var2);

    public JsonArray getAsJsonArray();

    public void raw(JsonArrayConsumer var1);

    default public <T> MappedValue<T> unwrapRaw(JsonArrayFunction<T> mapping) {
        return MappedValue.of(mapping.apply(this.getAsJsonArray()));
    }

    default public <T> MappedValue<T> mapWhole(ArrayValueFunction<T> mapping) {
        return MappedValue.of(mapping.apply(this));
    }

    default public MappedArrayValue<IntValue> ints() {
        return this.map(Any::intValue);
    }

    default public MappedArrayValue<LongValue> longs() {
        return this.map(Any::longValue);
    }

    default public MappedArrayValue<FloatValue> floats() {
        return this.map(Any::floatValue);
    }

    default public MappedArrayValue<DoubleValue> doubles() {
        return this.map(Any::doubleValue);
    }

    default public MappedArrayValue<BooleanValue> booleans() {
        return this.map(Any::bool);
    }

    default public MappedArrayValue<StringValue> strings() {
        return this.map(Any::string);
    }
}

