/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Callable;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Undefined;
import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorLikeIterable
implements Iterable<Object>,
Closeable {
    private final Context cx;
    private final Scriptable scope;
    private final Callable next;
    private final Callable returnFunc;
    private final Scriptable iterator;
    private boolean closed;

    public IteratorLikeIterable(Context cx, Scriptable scope, Object target) {
        this.cx = cx;
        this.scope = scope;
        this.next = ScriptRuntime.getPropFunctionAndThis(cx, scope, target, "next");
        this.iterator = ScriptRuntime.lastStoredScriptable(cx);
        Object retObj = ScriptRuntime.getObjectPropNoWarn(cx, scope, target, "return");
        if (retObj != null && !Undefined.isUndefined(retObj)) {
            if (!(retObj instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(cx, target, retObj, "return");
            }
            this.returnFunc = (Callable)retObj;
        } else {
            this.returnFunc = null;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.returnFunc != null) {
                this.returnFunc.call(this.cx, this.scope, this.iterator, ScriptRuntime.EMPTY_OBJECTS);
            }
        }
    }

    public Itr iterator() {
        return new Itr();
    }

    public final class Itr
    implements Iterator<Object> {
        private Object nextVal;
        private boolean isDone;

        @Override
        public boolean hasNext() {
            Object val = IteratorLikeIterable.this.next.call(IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope, IteratorLikeIterable.this.iterator, ScriptRuntime.EMPTY_OBJECTS);
            Object doneval = ScriptableObject.getProperty(ScriptableObject.ensureScriptable(val, IteratorLikeIterable.this.cx), "done", IteratorLikeIterable.this.cx);
            if (doneval == Scriptable.NOT_FOUND) {
                doneval = Undefined.instance;
            }
            if (ScriptRuntime.toBoolean(IteratorLikeIterable.this.cx, doneval)) {
                this.isDone = true;
                return false;
            }
            this.nextVal = ScriptRuntime.getObjectPropNoWarn(IteratorLikeIterable.this.cx, IteratorLikeIterable.this.scope, val, "value");
            return true;
        }

        @Override
        public Object next() {
            if (this.isDone) {
                throw new NoSuchElementException();
            }
            return this.nextVal;
        }
    }
}

