/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Callable;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Undefined;
import org.jetbrains.annotations.Nullable;

public enum MemberType {
    UNDEFINED("undefined"),
    OBJECT("object"),
    FUNCTION("function"),
    SYMBOL("symbol"),
    STRING("string"),
    NUMBER("number"),
    BOOLEAN("boolean");

    private final String name;

    public static MemberType get(@Nullable Object value, Context cx) {
        if (value == null) {
            return OBJECT;
        }
        if (value == Undefined.instance) {
            return UNDEFINED;
        }
        if (value instanceof Scriptable) {
            return value instanceof Callable ? FUNCTION : ((Scriptable)value).getTypeOf();
        }
        if (value instanceof CharSequence) {
            return STRING;
        }
        if (value instanceof Number) {
            return NUMBER;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", value, cx);
    }

    private MemberType(String n2) {
        this.name = n2;
    }

    public String toString() {
        return this.name;
    }
}

